/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCIEBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public class PDFColorSpaceLab
extends PDFColorSpaceCIEBased {
    private PDFColorSpaceLab(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceLab getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceLab pdfObject = (PDFColorSpaceLab)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceLab.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceLab(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ColorSpace createColorSpace() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ASName getName() {
        return ASName.k_Lab;
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public double[] getRange() {
        try {
            CosArray range = this.getDictionary().getDictionaryArrayValue(ASName.k_Range);
            if (range == null) {
                return new double[]{0.0, 100.0, -100.0, 100.0, -100.0, 100.0};
            }
            return new double[]{0.0, 100.0, range.getDouble(0), range.getDouble(1), range.getDouble(2), range.getDouble(3)};
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    public void setRange(double[] range) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (range != null && (range.length != 4 || range[0] > range[1] || range[2] > range[3])) {
            throw new PDFInvalidParameterException("range array passed is invalid.");
        }
        this.getDictionary().setDictionaryArrayValue(ASName.k_Range, range);
    }

    @Override
    public double[] getWhitePoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getWhitePoint();
    }

    @Override
    public void setWhitePoint(double[] whitePoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        super.setWhitePoint(whitePoint);
    }

    @Override
    public double[] getBlackPoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return super.getBlackPoint();
    }

    @Override
    public void setBlackPoint(double[] blackPoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        super.setBlackPoint(blackPoint);
    }

    @Override
    public double[] toRGB(double[] lab) {
        lab = super.toRGB(lab);
        try {
            return ColorManager.convertLabToRGB(lab, this.getWhitePoint());
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] getDefaultColor() {
        return PDFColorSpaceDeviceRGB.defaultColor;
    }
}

