/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public class PDFColorSpacePattern
extends PDFColorSpace {
    private PDFColorSpacePattern(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpace getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpacePattern pdfObject = (PDFColorSpacePattern)PDFCosObject.getCachedInstance(cosObject, PDFColorSpacePattern.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpacePattern(cosObject);
        }
        return pdfObject;
    }

    public static PDFColorSpacePattern newInstance(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray array = PDFCosObject.newCosArray(pdfDoc);
        array.addName(ASName.k_Pattern);
        return new PDFColorSpacePattern(array);
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ColorSpace createColorSpace() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    @Override
    public ASName getName() {
        return ASName.k_Pattern;
    }

    @Override
    public int getNumberOfComponents() {
        throw new PDFUnsupportedFeatureException(this.getName().asString(true));
    }

    public ASName getPatternColorSpaceName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject item1;
        CosObject obj = this.getCosObject();
        if (obj.getType() == 5 && this.getCosArray().size() > 1 && (item1 = ((CosArray)obj).get(1)).getType() == 3) {
            return ((CosName)item1).nameValue();
        }
        return null;
    }

    public void setPatternColorSpaceName(ASName csName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getCosObject();
        if (obj.getType() == 5) {
            if (((CosArray)obj).size() > 1) {
                ((CosArray)obj).set(1, PDFCosObject.newCosName(this.getPDFDocument(), csName));
            } else {
                ((CosArray)obj).add(1, PDFCosObject.newCosName(this.getPDFDocument(), csName));
            }
        }
    }

    public PDFColorSpace getPatternColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getCosObject();
        if (obj.getType() == 5 && ((CosArray)obj).size() > 1) {
            return PDFColorSpaceFactory.getInstance(((CosArray)obj).get(1));
        }
        return null;
    }

    @Override
    public double[] getRange() {
        try {
            return this.getPatternColorSpace().getRange();
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] toRGB(double[] inputColorValues) {
        try {
            inputColorValues = super.toRGB(inputColorValues);
            PDFColorSpace patternCS = this.getPatternColorSpace();
            if (patternCS != null) {
                return patternCS.toRGB(inputColorValues);
            }
            return null;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
    }

    @Override
    public double[] getDefaultColor() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFColorSpace patternCS = this.getPatternColorSpace();
        if (patternCS != null) {
            return patternCS.getDefaultColor();
        }
        return null;
    }
}

