/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDVerticalMetrics;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import java.io.IOException;

public final class PDFCIDFont
extends PDFCosDictionary {
    private PDFCIDFont(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFCIDFont getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCIDFont pdfObject = (PDFCIDFont)PDFCosObject.getCachedInstance(cosObject, PDFCIDFont.class);
        if (pdfObject == null) {
            pdfObject = new PDFCIDFont(cosObject);
        }
        return pdfObject;
    }

    public static PDFCIDFont newInstance(PDFDocument pdfDocument, ASName baseFont, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = pdfDocument.getCosDocument().createCosDictionary();
        PDFCIDFont pdfObject = new PDFCIDFont(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Font);
        pdfObject.setDictionaryNameValue(ASName.k_Subtype, subType);
        pdfObject.setBaseFont(baseFont);
        return pdfObject;
    }

    public ASName getSubType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getName(ASName.k_Subtype);
    }

    public ASName getBaseFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getName(ASName.k_BaseFont);
    }

    public void setBaseFont(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_BaseFont, fontName);
    }

    public PDFCIDSystemInfo getCIDSystemInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_CIDSystemInfo);
        return PDFCIDSystemInfo.getInstance(cosObj);
    }

    public void setCIDSystemInfo(PDFCIDSystemInfo cidSystemInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_CIDSystemInfo, cidSystemInfo);
    }

    public PDFFontDescriptor getFontDescriptor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObj = this.getCosDictionary().getCosDictionary(ASName.k_FontDescriptor);
        return PDFFontDescriptor.getInstance(cosObj);
    }

    public void setFontDescriptor(PDFFontDescriptor fontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fontDescriptor == null || fontDescriptor.getPDFCosDescriptor() == null) {
            throw new PDFInvalidParameterException("Font descriptor is a required parameter and hence can't be null");
        }
        this.setDictionaryValue(ASName.k_FontDescriptor, fontDescriptor.getPDFCosDescriptor());
    }

    public int getDW() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int kDefaultWidth = 1000;
        if (this.getCosDictionary().containsKey(ASName.k_DW)) {
            return this.getCosDictionary().getInt(ASName.k_DW);
        }
        return kDefaultWidth;
    }

    public void setDW(int defaultWidth) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_DW, defaultWidth);
    }

    public PDFCIDFontWidths getW() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObj = this.getCosDictionary().getCosArray(ASName.k_W);
        return PDFCIDFontWidths.getInstance(cosObj);
    }

    public void setW(PDFCIDFontWidths cidFontWidths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosWidths = cidFontWidths.toCosArray();
        this.getCosDictionary().put(ASName.k_W, cosWidths);
    }

    public void setW2(PDFCIDVerticalMetrics verticalMatrices) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().put(ASName.k_W2, verticalMatrices.getCosObject());
    }

    public int[] getDW2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int[] dw = new int[2];
        if (this.getCosDictionary().containsKey(ASName.k_DW2)) {
            CosArray array = this.getCosDictionary().getCosArray(ASName.k_DW2);
            dw[0] = array.getInt(0);
            dw[1] = array.getInt(1);
        } else {
            dw[0] = 880;
            dw[1] = -1000;
        }
        return dw;
    }

    public PDFCIDVerticalMetrics getW2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObj = this.getCosDictionary().getCosArray(ASName.k_W2);
        return PDFCIDVerticalMetrics.getInstance(cosObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cid2gid(int cid) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject obj;
            if (this.getCosDictionary().containsKey(ASName.k_CIDToGIDMap) && (obj = this.getCosDictionary().get(ASName.k_CIDToGIDMap)) instanceof CosStream) {
                int gid;
                CosStream stream = (CosStream)obj;
                try (InputByteStream is = stream.getStreamDecoded();){
                    is.seek(2L * (long)cid);
                    gid = is.read() << 8 | is.read();
                }
                return gid;
            }
            return cid;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean hasCIDToGIDMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubType() != ASName.k_CIDFontType2) {
            return false;
        }
        return super.dictionaryContains(ASName.k_CIDToGIDMap);
    }

    public boolean isCIDToGIDMapAStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubType() != ASName.k_CIDFontType2) {
            return false;
        }
        return super.getDictionaryCosObjectValue(ASName.k_CIDToGIDMap) instanceof CosStream;
    }

    public PDFStream getCIDToGIDMapStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubType() != ASName.k_CIDFontType2) {
            return null;
        }
        CosStream stream = (CosStream)super.getDictionaryCosObjectValue(ASName.k_CIDToGIDMap);
        if (stream == null) {
            return null;
        }
        return PDFStream.getInstance(stream);
    }

    public boolean isCIDToGIDMapAName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubType() != ASName.k_CIDFontType2) {
            return false;
        }
        return super.getDictionaryCosObjectValue(ASName.k_CIDToGIDMap) instanceof CosName;
    }

    public ASName getCIDToGIDMapName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getSubType() != ASName.k_CIDFontType2) {
            return null;
        }
        return this.getDictionaryNameValue(ASName.k_CIDToGIDMap);
    }
}

