/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapObjectImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class PDFCMap {
    private static HashMap<String, CMapObject> mPredefinedCMmaps = new HashMap();
    private CMapObject mCharCodeCMap;
    private CMapObject mUnicodeCMap;
    private int mWritingMode = 0;
    private MissingResourceException exceptionInLoadingMUnicodeMap = null;

    public PDFCMap(String cmapName) throws PDFInvalidDocumentException {
        if ("Identity-H".equals(cmapName)) {
            this.mWritingMode = 0;
        } else if ("Identity-V".equals(cmapName)) {
            this.mWritingMode = 1;
        } else {
            this.mCharCodeCMap = PDFCMap.getCMapObjectForName(cmapName);
            String writingMode = this.mCharCodeCMap.getWritingMode();
            if (!"0".equals(writingMode) && !"1".equals(writingMode)) {
                throw new PDFInvalidDocumentException("Illegal writing mode");
            }
            this.mWritingMode = writingMode.charAt(0) - 48;
            try {
                this.loadUnicodeCMap(this.mCharCodeCMap.getRegistry(), this.mCharCodeCMap.getOrdering());
            }
            catch (MissingResourceException e) {
                this.exceptionInLoadingMUnicodeMap = e;
            }
        }
    }

    public static synchronized CMapObject getCMapObjectForName(String cmapName) throws MissingResourceException {
        CMapObject cmap;
        if (mPredefinedCMmaps.containsKey(cmapName)) {
            cmap = mPredefinedCMmaps.get(cmapName);
        } else {
            cmap = CMapObjectImpl.get(cmapName);
            mPredefinedCMmaps.put(cmapName, cmap);
        }
        return cmap;
    }

    public PDFCMap(InputStream cmapStream, Map<String, InputStream> useCMaps) throws PDFInvalidDocumentException {
        this.mCharCodeCMap = CMapObjectImpl.get(cmapStream, useCMaps);
        String writingMode = this.mCharCodeCMap.getWritingMode();
        if (!"0".equals(writingMode) && !"1".equals(writingMode)) {
            throw new PDFInvalidDocumentException("Illegal writing mode");
        }
        this.mWritingMode = writingMode.charAt(0) - 48;
        try {
            this.loadUnicodeCMap(this.mCharCodeCMap.getRegistry(), this.mCharCodeCMap.getOrdering());
        }
        catch (MissingResourceException e) {
            this.exceptionInLoadingMUnicodeMap = e;
        }
    }

    public int getMinBytesNeeded() {
        if (this.mCharCodeCMap == null) {
            return 2;
        }
        return this.mCharCodeCMap.getMinBytesNeeded();
    }

    public int getMaxBytesAllowed() {
        if (this.mCharCodeCMap == null) {
            return 2;
        }
        return this.mCharCodeCMap.getMaxBytesAllowed();
    }

    public int getCID(byte[] charCodeBytes) throws PDFInvalidDocumentException {
        long charCode = PDFCMapUtils.getCharCode(charCodeBytes);
        return this.getCID(charCode);
    }

    public int getCID(long charCode) throws PDFInvalidDocumentException {
        if (this.mCharCodeCMap == null) {
            return (int)charCode;
        }
        int[] values = this.mCharCodeCMap.getValue(charCode);
        if (values == null) {
            return -1;
        }
        if (values.length > 1) {
            throw new PDFInvalidDocumentException("Character code is mapped to more than one CID");
        }
        return values[0];
    }

    public int[] getUnicodeIdentity(String registry, String ordering, byte[] charCodeBytes) throws PDFInvalidDocumentException {
        if (this.mCharCodeCMap != null) {
            throw new PDFInvalidDocumentException("CMap is not identity encoded");
        }
        this.loadUnicodeCMap(registry, ordering);
        return this.getUnicode(charCodeBytes);
    }

    public int[] getUnicode(byte[] charCodeBytes) throws PDFInvalidDocumentException {
        int cid = this.getCID(charCodeBytes);
        if (this.mUnicodeCMap == null) {
            throw new PDFInvalidDocumentException("Error in loading mUnicodeCMap", this.exceptionInLoadingMUnicodeMap);
        }
        return this.mUnicodeCMap.getValue(cid);
    }

    public String getUnicodeStringIdentity(String registry, String ordering, byte[] charCodeBytes) throws PDFInvalidDocumentException {
        if (this.mCharCodeCMap != null) {
            throw new PDFInvalidDocumentException("CMap is not identity encoded");
        }
        this.loadUnicodeCMap(registry, ordering);
        return this.getUnicodeString(charCodeBytes);
    }

    public String getUnicodeString(byte[] charCodeBytes) throws PDFInvalidDocumentException {
        int[] codePoints = this.getUnicode(charCodeBytes);
        if (codePoints == null || codePoints.length == 0) {
            return null;
        }
        StringBuilder unicodeStr = new StringBuilder();
        for (int i = 0; i < codePoints.length; ++i) {
            unicodeStr.append((char)codePoints[i]);
        }
        return unicodeStr.toString();
    }

    public long getSpaceCharCode() throws PDFInvalidDocumentException {
        if (this.mCharCodeCMap == null) {
            throw new PDFInvalidDocumentException("CMap is identity encoded");
        }
        return this.getSpaceCharCodeInternal(this.mCharCodeCMap);
    }

    public long getSpaceCharCodeIdentity(String registry, String ordering) throws PDFInvalidDocumentException {
        if (this.mCharCodeCMap != null) {
            throw new PDFInvalidDocumentException("CMap is not identity encoded");
        }
        this.loadUnicodeCMap(registry, ordering);
        return this.getSpaceCharCodeInternal(this.mUnicodeCMap);
    }

    private long getSpaceCharCodeInternal(CMapObject cmap) throws PDFInvalidDocumentException {
        HashMap<Long, Integer> spaceCharCodeMap = cmap.getSpaceCharCodeMap();
        if (spaceCharCodeMap == null || spaceCharCodeMap.isEmpty()) {
            throw new PDFInvalidDocumentException("Space character cannot be found in CMap");
        }
        Object[] keys = spaceCharCodeMap.keySet().toArray();
        long[] charCodes = new long[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            charCodes[i] = (Long)keys[i];
            int unicode = spaceCharCodeMap.get(keys[i]);
            if (unicode != 32) continue;
            return charCodes[i];
        }
        return charCodes[0];
    }

    public static CMapObject getUnicodeCMapForROS(String registry, String ordering) {
        String unicodeCMapName = registry + "-" + ordering + "-" + "UCS2";
        return PDFCMap.getCMapObjectForName(unicodeCMapName);
    }

    private void loadUnicodeCMap(String registry, String ordering) throws PDFInvalidDocumentException {
        String unicodeCMapName = registry + "-" + ordering + "-" + "UCS2";
        if (this.mUnicodeCMap == null) {
            this.mUnicodeCMap = PDFCMap.getCMapObjectForName(unicodeCMapName);
            if (this.mUnicodeCMap == null) {
                throw new PDFInvalidDocumentException("Error in loading mUnicodeCMap", this.exceptionInLoadingMUnicodeMap);
            }
        }
        if (!(unicodeCMapName = registry + "_" + ordering + "_" + "UCS2").equals(this.mUnicodeCMap.getOrdering())) {
            throw new PDFInvalidDocumentException("Ordering mismatch");
        }
    }

    public PDFWritingMode getWritingMode() {
        if (this.mWritingMode == 0) {
            return PDFWritingMode.HORIZONTAL;
        }
        return PDFWritingMode.VERTICAL;
    }

    public String getUseCMap() {
        if (this.mCharCodeCMap == null) {
            return null;
        }
        return this.mCharCodeCMap.getBaseName();
    }

    public CMapObject getCharCodeCMap() {
        return this.mCharCodeCMap;
    }

    public CMapObject getUnicodeCMap() {
        return this.mUnicodeCMap;
    }
}

