/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFStandardFontDescriptors;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSet;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontStretch;

public class PDFFontDescriptor {
    private final PDFCosFontDescriptor cosDesc;
    private final ASDictionary dictDesc;
    public static final int kFixedPitch = 1;
    public static final int kSerif = 2;
    public static final int kSymbolic = 4;
    public static final int kScript = 8;
    public static final int kNonsymbolic = 32;
    public static final int kItalic = 64;
    public static final int kAllCap = 65536;
    public static final int kSmallCap = 131072;
    public static final int kForceBold = 262144;

    private PDFFontDescriptor(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.cosDesc = PDFCosFontDescriptor.newInstance(pdfDocument);
        this.dictDesc = null;
    }

    private PDFFontDescriptor(CosObject cosObject) throws PDFInvalidDocumentException {
        this.cosDesc = PDFCosFontDescriptor.getInstance(cosObject);
        this.dictDesc = null;
    }

    private PDFFontDescriptor(ASDictionary dict) {
        dict.put(ASName.k_Type, ASName.k_FontDescriptor);
        this.cosDesc = null;
        this.dictDesc = dict;
    }

    public static PDFFontDescriptor newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFFontDescriptor(pdfDocument);
    }

    public static PDFFontDescriptor newInstance(PDFDocument pdfDocument, ASName fontKeyName, PDFFontDescription afeFontDescription) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        String base14Name;
        int flags = 0;
        double italicAngle = afeFontDescription.getItalicAngle();
        if (Math.round(italicAngle) != 0L) {
            flags |= 0x40;
        }
        flags = (base14Name = afeFontDescription.getBase14Name()) == null ? (flags |= 0x20) : ("Symbol".equals(base14Name) || "ZapfDingbats".equals(base14Name) ? (flags |= 4) : (flags |= 0x20));
        return PDFFontDescriptor.newInstance(pdfDocument, fontKeyName, afeFontDescription, flags);
    }

    public static PDFFontDescriptor newInstance(PDFDocument pdfDocument, ASName fontKeyName, PDFFontDescription afeFontDescription, int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(pdfDocument);
        fontDescriptor.setType(ASName.k_FontDescriptor);
        if (fontKeyName != null) {
            fontDescriptor.setFontName(fontKeyName);
        }
        fontDescriptor.setFlags(flags);
        ASRectangle asrect = PDFFontDescriptor.getRectangleCoords(afeFontDescription.getFontBBox());
        fontDescriptor.setFontBBox(asrect);
        fontDescriptor.setItalicAngle(afeFontDescription.getItalicAngle());
        fontDescriptor.setCapHeight(afeFontDescription.getCapHeight());
        fontDescriptor.setXHeight(afeFontDescription.getXHeight());
        fontDescriptor.setAscent(Math.ceil(asrect.top()));
        fontDescriptor.setDescent(Math.floor(asrect.bottom()));
        fontDescriptor.setStemV(afeFontDescription.getStemV());
        return fontDescriptor;
    }

    public static PDFFontDescriptor newInstance(PDFFontDescriptor oldFontDesc, PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(document);
        fontDescriptor.setType(ASName.create("FontDescriptor"));
        fontDescriptor.setFlags(oldFontDesc.getFlags());
        fontDescriptor.setFontBBox(oldFontDesc.getFontBBox());
        fontDescriptor.setItalicAngle(oldFontDesc.getItalicAngle());
        fontDescriptor.setCapHeight(oldFontDesc.getCapHeight());
        fontDescriptor.setXHeight(oldFontDesc.getXHeight());
        fontDescriptor.setAscent(oldFontDesc.getAscent());
        fontDescriptor.setDescent(oldFontDesc.getDescent());
        fontDescriptor.setStemV(oldFontDesc.getStemV());
        return fontDescriptor;
    }

    private static ASRectangle getRectangleCoords(Rect bbox) {
        double x_left = bbox.xmin;
        double y_bottom = bbox.ymin;
        double x_right = bbox.xmax;
        double y_top = bbox.ymax;
        return new ASRectangle(x_left, y_bottom, x_right, y_top);
    }

    public static PDFFontDescriptor getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        return new PDFFontDescriptor(cosObject);
    }

    static PDFFontDescriptor newInstance(ASName name) throws PDFInvalidParameterException {
        if (name == null) {
            return null;
        }
        return new PDFFontDescriptor(PDFStandardFontDescriptors.get(name));
    }

    public PDFCosFontDescriptor getPDFCosDescriptor() {
        return this.cosDesc;
    }

    public ASDictionary getPDFDictDescriptor() {
        return this.dictDesc;
    }

    public ASName getFontName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontName();
        }
        try {
            return this.dictDesc.getName(ASName.k_FontName);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
        }
    }

    public void setFontName(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setFontName(fontName);
        } else if (this.dictDesc != null) {
            this.dictDesc.put(ASName.k_FontName, fontName);
        }
    }

    public ASString getFontFamily() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontFamily();
        }
        if (this.dictDesc.containsKey(ASName.k_FontFamily)) {
            try {
                return this.dictDesc.getString(ASName.k_FontFamily);
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return null;
    }

    public PDFFontStretch getFontStretch() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontStretch();
        }
        if (this.dictDesc.containsKey(ASName.k_FontStretch)) {
            try {
                ASName fontStretch = this.dictDesc.getName(ASName.k_FontStretch);
                return PDFFontStretch.newInstance(fontStretch);
            }
            catch (PDFUnableToCompleteOperationException e1) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e1);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid value for font stretch.", e);
            }
        }
        return null;
    }

    public int getFontWeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int kNormalWeight = 400;
        if (this.cosDesc != null) {
            return this.cosDesc.getFontWeight();
        }
        if (this.dictDesc.containsKey(ASName.k_FontWeight)) {
            try {
                return this.dictDesc.getNumber(ASName.k_FontWeight).intValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return kNormalWeight;
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFlags();
        }
        try {
            if (this.dictDesc.getNumber(ASName.k_Flags) != null) {
                return this.dictDesc.getNumber(ASName.k_Flags).intValue();
            }
            return 0;
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
        }
    }

    public void setFlags(int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setFlags(flags);
        } else if (this.dictDesc != null) {
            this.dictDesc.put(ASName.k_Flags, new ASNumber(flags));
        }
    }

    boolean containsFontBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.containsFontBBox();
        }
        return this.dictDesc.containsKey(ASName.k_FontBBox);
    }

    public ASRectangle getFontBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            try {
                return new ASRectangle(this.cosDesc.getFontBBox().getValues());
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException("Internal programming error.", e);
            }
        }
        if (this.dictDesc.containsKey(ASName.k_FontBBox)) {
            return (ASRectangle)this.dictDesc.get(ASName.k_FontBBox);
        }
        return null;
    }

    public void setFontBBox(ASRectangle fontBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            PDFRectangle pdfRectangle = PDFRectangle.newInstance(this.cosDesc.getPDFDocument(), fontBBox);
            this.cosDesc.setFontBBox(pdfRectangle);
        } else {
            this.dictDesc.put(ASName.k_FontBBox, fontBBox);
        }
    }

    public double getItalicAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getItalicAngle();
        }
        try {
            return this.dictDesc.getNumber(ASName.k_ItalicAngle).doubleValue();
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
        }
    }

    public void setItalicAngle(double angle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setItalicAngle(angle);
        } else {
            this.dictDesc.put(ASName.k_Flags, new ASNumber(angle));
        }
    }

    boolean containsAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.containsAscent();
        }
        return this.dictDesc.containsKey(ASName.k_Ascent);
    }

    public double getAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getAscent();
        }
        if (this.dictDesc.containsKey(ASName.k_Ascent)) {
            try {
                return this.dictDesc.getNumber(ASName.k_Ascent).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public void setAscent(double ascent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setAscent(ascent);
        } else {
            this.dictDesc.put(ASName.k_Ascent, new ASNumber(ascent));
        }
    }

    boolean containsDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.containsDescent();
        }
        return this.dictDesc.containsKey(ASName.k_Descent);
    }

    public double getDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getDescent();
        }
        if (this.dictDesc.containsKey(ASName.k_Descent)) {
            try {
                return this.dictDesc.getNumber(ASName.k_Descent).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public void setDescent(double descent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setDescent(descent);
        } else {
            this.dictDesc.put(ASName.k_Descent, new ASNumber(descent));
        }
    }

    public double getLeading() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getLeading();
        }
        if (this.dictDesc.containsKey(ASName.k_Leading)) {
            try {
                return this.dictDesc.getNumber(ASName.k_Leading).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    boolean containsCapHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.containsCapHeight();
        }
        return this.dictDesc.containsKey(ASName.k_CapHeight);
    }

    public double getCapHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getCapHeight();
        }
        if (this.dictDesc.containsKey(ASName.k_CapHeight)) {
            try {
                return this.dictDesc.getNumber(ASName.k_CapHeight).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public void setCapHeight(double capHight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setCapHeight(capHight);
        } else {
            this.dictDesc.put(ASName.k_CapHeight, new ASNumber(capHight));
        }
    }

    public double getXHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getXHeight();
        }
        if (this.dictDesc.containsKey(ASName.k_XHeight)) {
            try {
                return this.dictDesc.getNumber(ASName.k_XHeight).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public void setXHeight(double xHeight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setXHeight(xHeight);
        } else {
            this.dictDesc.put(ASName.k_XHeight, new ASNumber(xHeight));
        }
    }

    boolean containsStemV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.containsStemV();
        }
        return this.dictDesc.containsKey(ASName.k_StemV);
    }

    public double getStemV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getStemV();
        }
        if (this.dictDesc.containsKey(ASName.k_StemV)) {
            try {
                return this.dictDesc.getNumber(ASName.k_StemV).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public void setStemV(double stemV) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setStemV(stemV);
        } else {
            this.dictDesc.put(ASName.k_StemV, new ASNumber(stemV));
        }
    }

    double getStemH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getStemH();
        }
        if (this.dictDesc.containsKey(ASName.k_StemH)) {
            try {
                return this.dictDesc.getNumber(ASName.k_StemH).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    double getAvgWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getAvgWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_AvgWidth)) {
            try {
                return this.dictDesc.getNumber(ASName.k_AvgWidth).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    double getMaxWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getMaxWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_MaxWidth)) {
            try {
                return this.dictDesc.getNumber(ASName.k_MaxWidth).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public double getMissingWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getMissingWidth();
        }
        if (this.dictDesc.containsKey(ASName.k_MissingWidth)) {
            try {
                return this.dictDesc.getNumber(ASName.k_MissingWidth).doubleValue();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Standard Font Dict", e);
            }
        }
        return 0.0;
    }

    public boolean containsEmbeddedFont() {
        if (this.cosDesc == null) {
            return false;
        }
        return this.cosDesc.containsEmbeddedFont();
    }

    public PDFFontFile getFontFile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontFile();
        }
        return null;
    }

    public PDFFontFile getFontFile2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontFile2();
        }
        return null;
    }

    public void setFontFile(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setFontFile(fontFile);
        }
    }

    public void setFontFile2(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setFontFile2(fontFile);
        }
    }

    public PDFFontFile getFontFile3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getFontFile3();
        }
        return null;
    }

    public void setFontFile3(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setFontFile3(fontFile);
        }
    }

    public ASName getLang() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getLang();
        }
        return null;
    }

    public void setType(ASName fontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setType(fontDescriptor);
        }
    }

    public ASString getCharSet() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return this.cosDesc.getDictionaryStringValue(ASName.k_CharSet);
        }
        return null;
    }

    public PDFCIDSet getCIDSet() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            return PDFCIDSet.getInstance(this.cosDesc.getDictionaryCosObjectValue(ASName.k_CIDSet));
        }
        return null;
    }

    public void setCharSet(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setDictionaryStringValue(ASName.k_CharSet, value);
        }
    }

    public void setCharSet(String value, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            this.cosDesc.setDictionaryStringValue(ASName.k_CharSet, value, unicode);
        }
    }

    public void setCIDSet(PDFCIDSet cidSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.cosDesc != null) {
            if (cidSet == null) {
                this.cosDesc.removeValue(ASName.k_CIDSet);
            } else {
                this.cosDesc.setDictionaryStreamValue(ASName.k_CIDSet, cidSet.getCosStream());
            }
        }
    }
}

