/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.AdobeGlyphList;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Stack;

public class PDFToUnicodeCMap
extends PDFCosStream {
    private static final byte[] prefixBytes = "/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry ( Adobe )\n/Ordering ( UCS )\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n< 0000 >< FFFF >\nendcodespacerange\n".getBytes();
    private static byte[] suffixBytes = "endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend\n".getBytes();
    private HashSet<CMapCodeMapping> toUnicodeMaps;

    private PDFToUnicodeCMap(CosObject cosObject, boolean empty) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
        if (empty) {
            this.toUnicodeMaps = new HashSet();
            return;
        }
        InputByteStream ibs = null;
        try {
            ibs = this.getCosStream().getStreamDecoded();
            this.toUnicodeMaps = CMapResourceBuilder.parseToUnicodeMap(ibs.toInputStream(), cosObject.getDocument().getOptions().skipCorruptObjects());
        }
        catch (PDFParseException e) {
            throw new PDFInvalidDocumentException(e);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            if (ibs != null) {
                try {
                    ibs.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to close stream.", e);
                }
            }
        }
    }

    static PDFToUnicodeCMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFToUnicodeCMap pdfObject = (PDFToUnicodeCMap)PDFCosObject.getCachedInstance(cosObject, PDFToUnicodeCMap.class);
        if (pdfObject == null) {
            try {
                pdfObject = new PDFToUnicodeCMap(cosObject, false);
            }
            catch (Exception e) {
                if (cosObject.getDocument().getOptions().skipCorruptObjects()) {
                    return null;
                }
                throw new PDFInvalidDocumentException(e);
            }
        }
        return pdfObject;
    }

    public static PDFToUnicodeCMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosObject = PDFCosObject.newCosStream(pdfDocument);
        return new PDFToUnicodeCMap(cosObject, true);
    }

    public String toUnicode(ASString string, boolean twoByteChars) {
        String result = null;
        if (twoByteChars) {
            char[] chars = string.getChars();
            result = this.toUnicode(chars, 0, chars.length);
        } else {
            byte[] bytes = string.getBytes();
            result = this.toUnicode(bytes, 0, bytes.length);
        }
        return result;
    }

    public String toUnicode(byte[] bytes, int start, int length) {
        if (length > 0 && bytes != null) {
            StringBuilder strBuf = new StringBuilder(bytes.length);
            for (int i = start; i < length; ++i) {
                strBuf.append(this.toUnicode(bytes[i] & 0xFF));
            }
            return strBuf.toString();
        }
        return null;
    }

    public String toUnicode(char[] chars, int start, int length) {
        if (length > 0 && chars != null) {
            StringBuilder strBuf = new StringBuilder(chars.length);
            for (int i = start; i < length; ++i) {
                strBuf.append(this.toUnicode(chars[i]));
            }
            return strBuf.toString();
        }
        return null;
    }

    public char[] toUnicode(int charCode) {
        char[] unicodeChar = new char[]{'\ufffd'};
        if (this.toUnicodeMaps != null) {
            for (CMapCodeMapping codeMap : this.toUnicodeMaps) {
                if (!codeMap.contains(charCode)) continue;
                if (codeMap.isHexData(charCode)) {
                    return codeMap.getHexDataAsCharArray(charCode);
                }
                AdobeGlyphList glyphList = AdobeGlyphList.get();
                ASName glyphName = ASName.create(codeMap.getCharName(charCode));
                return glyphList.toUnicode(glyphName);
            }
        }
        return unicodeChar;
    }

    public int fromUnicode(char unicode) {
        int charCodeDefault = -1;
        if (this.toUnicodeMaps != null) {
            for (CMapCodeMapping codeMap : this.toUnicodeMaps) {
                int start = codeMap.getStartCode();
                int end = codeMap.getEndCode();
                for (int charCode = start; charCode <= end; ++charCode) {
                    char[] chars = null;
                    if (codeMap.isHexData(charCode)) {
                        chars = codeMap.getHexDataAsCharArray(charCode);
                    } else {
                        AdobeGlyphList glyphList = AdobeGlyphList.get();
                        ASName cmGlyphName = ASName.create(codeMap.getCharName(charCode));
                        chars = glyphList.toUnicode(cmGlyphName);
                    }
                    if (chars.length != 1 || chars[0] != unicode) continue;
                    return charCode;
                }
            }
        }
        return charCodeDefault;
    }

    PDFToUnicodeCMap getUseCMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFToUnicodeCMap.getInstance(this.getDictionaryCosObjectValue(ASName.k_UseCMap));
    }

    public void mergeToUnicodeCMap(ArrayList<CMapCodeMapping> toUnicodeCMap) {
        if (toUnicodeCMap != null) {
            this.toUnicodeMaps.addAll(toUnicodeCMap);
        }
    }

    public Locale getLocale() {
        for (CMapCodeMapping mapping : this.toUnicodeMaps) {
            int startCode = mapping.startCode;
            int endCode = mapping.endCode;
            for (int i = startCode; i <= endCode; ++i) {
                byte[] unicodeBytes;
                Locale locale;
                if (!mapping.isHexData(i) || (locale = PDFFontUtils.getLocaleFromUnicode(unicodeBytes = mapping.getHexData(i))) == null) continue;
                return locale;
            }
        }
        return null;
    }

    private Stack<CMapCodeMapping> optimize(CMapCodeMapping[] mappings) {
        Stack<CMapCodeMapping> stack = new Stack<CMapCodeMapping>();
        for (int i = 0; i < mappings.length; ++i) {
            CMapCodeMapping current = mappings[i];
            if (i == 0) {
                stack.push(current);
                continue;
            }
            CMapCodeMapping temp = stack.peek();
            if (temp.equals(current)) continue;
            if (this.byteRangesEqual(temp, current) && current.getStartCode() - temp.getEndCode() == 1) {
                ArrayList<Object> currentDataArray = current.getData();
                ArrayList<Object> tempDataArray = temp.getData();
                if (currentDataArray.size() == 1 && tempDataArray.size() == 1) {
                    char[] tempUnicode;
                    char[] currentUnicode;
                    Object tempData = tempDataArray.get(0);
                    Object currentData = currentDataArray.get(0);
                    if (tempData instanceof byte[] && currentData instanceof byte[] && ((byte[])tempData)[0] <= 255 - current.getEndCode() + temp.getStartCode() && (currentUnicode = current.toUnicode(currentData)).length == (tempUnicode = temp.toUnicode(tempData)).length && currentUnicode[0] - tempUnicode[0] == 1 + temp.getEndCode() - temp.getStartCode()) {
                        boolean equal = true;
                        for (int idx = 1; idx < currentUnicode.length; ++idx) {
                            if (currentUnicode[idx] == tempUnicode[idx]) continue;
                            equal = false;
                            break;
                        }
                        if (equal) {
                            stack.pop();
                            stack.push(new CMapCodeMapping(temp.getStartCode(), current.getEndCode(), tempDataArray));
                            continue;
                        }
                    }
                }
            }
            stack.push(current);
        }
        return stack;
    }

    private boolean byteRangesEqual(CMapCodeMapping first, CMapCodeMapping second) {
        return first.getEndCode() / 256 == second.getStartCode() / 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream() throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        OutputByteStream outStream = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        PDFFilterFlate filter = PDFFilterFlate.newInstance(this.getPDFDocument(), null);
        PDFFilterList filterList = PDFFilterList.newInstance(this.getPDFDocument());
        filterList.add(filter);
        this.setOutputFilters(filterList);
        Object[] mappings = new CMapCodeMapping[this.toUnicodeMaps.size()];
        this.toUnicodeMaps.toArray(mappings);
        Arrays.sort(mappings);
        outStream.write(prefixBytes);
        Stack<CMapCodeMapping> stack = this.optimize((CMapCodeMapping[])mappings);
        this.writeRangeToStream(outStream, stack);
        outStream.write(suffixBytes);
        InputByteStream ibs = null;
        InputStream is = null;
        try {
            ibs = outStream.closeAndConvert();
            is = ibs.toInputStream();
            this.setStreamData(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (ibs != null) {
                    ibs.close();
                }
            }
        }
    }

    private void writeRangeToStream(OutputByteStream outStream, List<CMapCodeMapping> list) throws IOException {
        int rangesWritten = 0;
        while (rangesWritten < list.size()) {
            int count = list.size() - rangesWritten < 100 ? list.size() - rangesWritten : 100;
            outStream.write((count + " beginbfrange").getBytes());
            for (int i = 0; i < count; ++i) {
                outStream.write(("\n" + list.get(rangesWritten).toString()).getBytes());
                ++rangesWritten;
            }
            outStream.write("\nendbfrange\n".getBytes());
        }
    }

    public HashSet<CMapCodeMapping> getCmapCodeMappings() {
        return this.toUnicodeMaps;
    }

    public static class CMapCodeMapping
    implements Comparable<Object> {
        private final int startCode;
        private final int endCode;
        private final ArrayList<Object> data;

        public CMapCodeMapping(int startCode) {
            this.startCode = startCode;
            this.endCode = startCode;
            this.data = new ArrayList();
        }

        public CMapCodeMapping(int startCode, int endCode) {
            this.startCode = startCode;
            this.endCode = endCode;
            this.data = new ArrayList();
        }

        public CMapCodeMapping(int startCode, int endCode, ArrayList<?> data) {
            this(startCode, endCode);
            this.data.addAll(data);
        }

        public boolean equals(CMapCodeMapping codeMap) {
            return this.startCode == codeMap.startCode && this.endCode == codeMap.endCode && this.compare(this.data, codeMap.data);
        }

        private boolean compare(ArrayList<?> a, ArrayList<?> b) {
            ListIterator<?> e1 = a.listIterator();
            ListIterator<?> e2 = b.listIterator();
            if (e1.hasNext() && e2.hasNext()) {
                Object o1 = e1.next();
                Object o2 = e2.next();
                if (o1 == null) {
                    return o2 == null;
                }
                if (o1 instanceof byte[] && o2 instanceof byte[]) {
                    return Arrays.equals((byte[])o1, (byte[])o2);
                }
                return o1.equals(o2);
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        public int hashCode() {
            return this.startCode + this.endCode << 2;
        }

        public void addHexData(byte[] charDesc) {
            this.data.add(charDesc);
        }

        public void addCharName(String charName) {
            this.data.add(charName);
        }

        public int getStartCode() {
            return this.startCode;
        }

        public int getEndCode() {
            return this.endCode;
        }

        public boolean contains(int charCode) {
            return charCode >= this.startCode && charCode <= this.endCode;
        }

        public boolean isHexData(int charCode) {
            if (this.data.size() == 1) {
                return this.data.get(0) instanceof byte[];
            }
            return this.data.get(charCode - this.startCode) instanceof byte[];
        }

        boolean isCharName(int charCode) {
            return !this.isHexData(charCode);
        }

        byte[] getHexData(int charCode) {
            if (this.data.size() == 1) {
                return (byte[])this.data.get(0);
            }
            return (byte[])this.data.get(charCode - this.startCode);
        }

        public char[] getHexDataAsCharArray(int charCode) {
            byte[] bytes;
            if (this.data.size() == 1) {
                bytes = (byte[])this.data.get(0);
                if (charCode > this.startCode) {
                    byte[] newBytes = new byte[bytes.length];
                    System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                    int lowByte = 0xFF & bytes[bytes.length - 1];
                    newBytes[bytes.length - 1] = (byte)((lowByte += charCode - this.startCode) & 0xFF);
                    bytes = newBytes;
                }
            } else {
                bytes = (byte[])this.data.get(charCode - this.startCode);
            }
            return CMapCodeMapping.getCharsFromBytes(bytes);
        }

        private static char[] getCharsFromBytes(byte[] bytes) {
            try {
                return new String(bytes, "UTF-16BE").toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                char[] chars = null;
                if (bytes != null && (chars = new char[(bytes.length + 1) / 2]).length != 0) {
                    int i;
                    for (i = 0; i < chars.length - 1; ++i) {
                        chars[i] = (char)(((bytes[i * 2] & 0xFF) << 8) + (bytes[i * 2 + 1] & 0xFF));
                    }
                    chars[chars.length - 1] = bytes.length % 2 == 0 ? (char)(((bytes[i * 2] & 0xFF) << 8) + (bytes[i * 2 + 1] & 0xFF)) : (char)(bytes[bytes.length - 1] & 0xFF);
                }
                return chars;
            }
        }

        public String getCharName(int charCode) {
            if (this.data.size() == 1) {
                return (String)this.data.get(0);
            }
            return (String)this.data.get(charCode - this.startCode);
        }

        @Override
        public int compareTo(CMapCodeMapping codeMap) {
            int thisVal = this.startCode;
            int otherVal = codeMap.startCode;
            return thisVal < otherVal ? -1 : (thisVal == otherVal ? 0 : 1);
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((CMapCodeMapping)o);
        }

        public String toString() {
            String startEndStr = "<" + this.getPaddedHexString(Integer.toHexString(this.startCode)) + "> <" + this.getPaddedHexString(Integer.toHexString(this.endCode)) + "> ";
            StringBuilder dataStr = new StringBuilder("");
            Iterator<Object> iter = this.data.iterator();
            int size = this.data.size();
            if (size > 1) {
                dataStr.append("[");
            }
            while (iter.hasNext()) {
                Object o = iter.next();
                this.appendDataString(this.toUnicode(o), dataStr);
            }
            if (size > 1) {
                dataStr.append("]");
            }
            return startEndStr + dataStr;
        }

        char[] toUnicode(Object o) {
            if (o instanceof byte[]) {
                return CMapCodeMapping.getCharsFromBytes((byte[])o);
            }
            if (o instanceof String) {
                AdobeGlyphList glyphList = AdobeGlyphList.get();
                ASName glyphName = ASName.create((String)o);
                return glyphList.toUnicode(glyphName);
            }
            throw new IllegalArgumentException("Types in data of CMapCodeMapping should be either string or byte array.");
        }

        private void appendDataString(char[] charArray, StringBuilder dataStr) {
            dataStr.append(" <");
            for (int i = 0; i < charArray.length; ++i) {
                dataStr.append(this.getPaddedHexString(Integer.toHexString(charArray[i])));
            }
            dataStr.append(">");
        }

        String getPaddedHexString(String hex) {
            int length = hex.length();
            if (length == 1) {
                return "000" + hex;
            }
            if (length == 2) {
                return "00" + hex;
            }
            if (length == 3) {
                return "0" + hex;
            }
            return hex;
        }

        public ArrayList<Object> getData() {
            return this.data;
        }
    }
}

