/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapObjectImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CompressedCmapLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.ZipInputStream;

public class CMapObjectCache {
    private static HashMap<String, CMapObject> cmapObjectCache;
    private static String COMPRESSED_CMAP_NAME;
    private static HashMap<String, Long> cmapPositionMap;
    private static final String ADOBE_COPYRIGHT = "%%Copyright: -----------------------------------------------------------\n%%Copyright: Copyright 1990-2009 Adobe Systems Incorporated.\n%%Copyright: All rights reserved.\n%%Copyright:\n%%Copyright: Redistribution and use in source and binary forms, with or\n%%Copyright: without modification, are permitted provided that the\n%%Copyright: following conditions are met:\n%%Copyright:\n%%Copyright: Redistributions of source code must retain the above\n%%Copyright: copyright notice, this list of conditions and the following\n%%Copyright: disclaimer.\n%%Copyright:\n%%Copyright: Redistributions in binary form must reproduce the above\n%%Copyright: copyright notice, this list of conditions and the following\n%%Copyright: disclaimer in the documentation and/or other materials\n%%Copyright: provided with the distribution. \n%%Copyright:\n%%Copyright: Neither the name of Adobe Systems Incorporated nor the names\n%%Copyright: of its contributors may be used to endorse or promote\n%%Copyright: products derived from this software without specific prior\n%%Copyright: written permission. \n%%Copyright:\n%%Copyright: THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND\n%%Copyright: CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES,\n%%Copyright: INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n%%Copyright: MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n%%Copyright: DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR\n%%Copyright: CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n%%Copyright: SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\n%%Copyright: NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n%%Copyright: LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n%%Copyright: HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n%%Copyright: CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR\n%%Copyright: OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n%%Copyright: SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n%%Copyright: -----------------------------------------------------------";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCmaps(CMapResourceBuilder builder, HashMap<Long, Integer> spaceCharMap) throws Exception {
        cmapObjectCache = new HashMap();
        InputStream cStream = CMapObjectCache.class.getResourceAsStream(COMPRESSED_CMAP_NAME);
        ZipInputStream zis = null;
        InputStreamReader isr = null;
        try {
            zis = new ZipInputStream(cStream);
            zis.getNextEntry();
            isr = new InputStreamReader(zis);
            CompressedCmapLineReader lineReader = new CompressedCmapLineReader(isr);
            while (!lineReader.actualEof()) {
                lineReader.resetCmapReader();
                CMapObjectImpl cmapObj = (CMapObjectImpl)builder.parseCMapFile(lineReader, null, false, spaceCharMap, false);
                String cmapName = lineReader.getCmapName();
                if (cmapName == null) continue;
                cmapObjectCache.put(cmapName, cmapObj);
            }
        }
        finally {
            block16: {
                try {
                    if (zis == null) break block16;
                    try {
                        zis.closeEntry();
                    }
                    finally {
                        zis.close();
                    }
                }
                finally {
                    if (isr != null) {
                        isr.close();
                    }
                }
            }
        }
    }

    static synchronized CMapObject getCmap(String name, CMapResourceBuilder builder, HashMap<Long, Integer> spaceCharMap) throws Exception {
        if (cmapObjectCache == null) {
            CMapObjectCache.loadCmaps(builder, spaceCharMap);
        }
        return cmapObjectCache.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InputByteStream getInputStreamForCmap(String cmapName, OutputByteStream outStream) throws IOException {
        long pos = cmapPositionMap.get(cmapName);
        InputStream cStream = CMapObjectCache.class.getResourceAsStream(COMPRESSED_CMAP_NAME);
        ZipInputStream zis = null;
        InputStreamReader isr = null;
        try {
            zis = new ZipInputStream(cStream);
            zis.getNextEntry();
            isr = new InputStreamReader(zis);
            isr.skip(pos);
            CompressedCmapLineReader lineReader = new CompressedCmapLineReader(isr);
            String line = null;
            outStream.write(ADOBE_COPYRIGHT.getBytes());
            while ((line = lineReader.readLine()) != null) {
                int countLess = 0;
                int countGreat = 0;
                for (char character : line.toCharArray()) {
                    if (character == '<') {
                        ++countLess;
                    }
                    if (character != '>') continue;
                    ++countGreat;
                }
                if (countGreat + countLess > 0) {
                    if (!line.startsWith("<")) {
                        line = "<" + line;
                        ++countLess;
                    }
                    if ((countGreat + countLess) % 2 == 1) {
                        line = line + ">";
                    }
                }
                outStream.write((line + "\n").getBytes());
            }
            outStream.write("%%EOF\n".getBytes());
        }
        finally {
            block21: {
                try {
                    if (zis == null) break block21;
                    try {
                        zis.closeEntry();
                    }
                    finally {
                        zis.close();
                    }
                }
                finally {
                    if (isr != null) {
                        isr.close();
                    }
                }
            }
        }
        return outStream.closeAndConvert();
    }

    static {
        COMPRESSED_CMAP_NAME = "merged_cmaps.zip";
        cmapPositionMap = new HashMap();
        cmapPositionMap.put("83pv-RKSJ-H", 0L);
        cmapPositionMap.put("90ms-RKSJ-H", 4042L);
        cmapPositionMap.put("90ms-RKSJ-V", 7350L);
        cmapPositionMap.put("90msp-RKSJ-H", 9253L);
        cmapPositionMap.put("90msp-RKSJ-V", 12531L);
        cmapPositionMap.put("90pv-RKSJ-H", 14420L);
        cmapPositionMap.put("Add-RKSJ-H", 19132L);
        cmapPositionMap.put("Add-RKSJ-V", 29558L);
        cmapPositionMap.put("Adobe-CNS1-UCS2", 31142L);
        cmapPositionMap.put("Adobe-GB1-UCS2", 222656L);
        cmapPositionMap.put("Adobe-Japan1-UCS2", 380611L);
        cmapPositionMap.put("Adobe-Korea1-UCS2", 586249L);
        cmapPositionMap.put("B5pc-H", 691575L);
        cmapPositionMap.put("B5pc-V", 696097L);
        cmapPositionMap.put("CNS-EUC-H", 696974L);
        cmapPositionMap.put("CNS-EUC-V", 705585L);
        cmapPositionMap.put("ETen-B5-H", 715044L);
        cmapPositionMap.put("ETen-B5-V", 719702L);
        cmapPositionMap.put("ETenms-B5-H", 720613L);
        cmapPositionMap.put("ETenms-B5-V", 721327L);
        cmapPositionMap.put("EUC-H", 722297L);
        cmapPositionMap.put("EUC-V", 724833L);
        cmapPositionMap.put("Ext-RKSJ-H", 725937L);
        cmapPositionMap.put("Ext-RKSJ-V", 736808L);
        cmapPositionMap.put("GB-EUC-H", 738122L);
        cmapPositionMap.put("GB-EUC-V", 740160L);
        cmapPositionMap.put("GBK-EUC-H", 741156L);
        cmapPositionMap.put("GBK-EUC-V", 805945L);
        cmapPositionMap.put("GBK2K-H", 806930L);
        cmapPositionMap.put("GBK2K-V", 881135L);
        cmapPositionMap.put("GBKp-EUC-H", 882442L);
        cmapPositionMap.put("GBKp-EUC-V", 947216L);
        cmapPositionMap.put("GBpc-EUC-H", 948207L);
        cmapPositionMap.put("GBpc-EUC-V", 950261L);
        cmapPositionMap.put("H", 951269L);
        cmapPositionMap.put("HKscs-B5-H", 953709L);
        cmapPositionMap.put("HKscs-B5-V", 971175L);
        cmapPositionMap.put("KSC-EUC-H", 972073L);
        cmapPositionMap.put("KSC-EUC-V", 979904L);
        cmapPositionMap.put("KSCms-UHC-H", 980865L);
        cmapPositionMap.put("KSCms-UHC-HW-H", 992076L);
        cmapPositionMap.put("KSCms-UHC-HW-V", 1003283L);
        cmapPositionMap.put("KSCms-UHC-V", 1004257L);
        cmapPositionMap.put("KSCpc-EUC-H", 1005232L);
        cmapPositionMap.put("UniCNS-UCS2-H", 1013714L);
        cmapPositionMap.put("UniCNS-UCS2-V", 1272364L);
        cmapPositionMap.put("UniCNS-UTF16-H", 1273272L);
        cmapPositionMap.put("UniCNS-UTF16-V", 1484792L);
        cmapPositionMap.put("UniGB-UCS2-H", 1485701L);
        cmapPositionMap.put("UniGB-UCS2-V", 1702757L);
        cmapPositionMap.put("UniGB-UTF16-H", 1703817L);
        cmapPositionMap.put("UniGB-UTF16-V", 1867685L);
        cmapPositionMap.put("UniJIS-UCS2-H", 1868677L);
        cmapPositionMap.put("UniJIS-UCS2-HW-H", 2001115L);
        cmapPositionMap.put("UniJIS-UCS2-HW-V", 2001908L);
        cmapPositionMap.put("UniJIS-UCS2-V", 2005692L);
        cmapPositionMap.put("UniJIS-UTF16-H", 2009410L);
        cmapPositionMap.put("UniJIS-UTF16-V", 2165973L);
        cmapPositionMap.put("UniKS-UCS2-H", 2169217L);
        cmapPositionMap.put("UniKS-UCS2-V", 2299623L);
        cmapPositionMap.put("UniKS-UTF16-H", 2300616L);
        cmapPositionMap.put("UniKS-UTF16-V", 2400434L);
        cmapPositionMap.put("V", 2401403L);
        cmapPositionMap.put("UniJIS2004-UTF16-H", 2402483L);
        cmapPositionMap.put("UniJIS2004-UTF16-V", 2559126L);
    }
}

