/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.impl;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.GlyphNames;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.GlyphIDHolder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.MacRomanEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PDFFontUtils {
    private PDFFontUtils() {
    }

    public static Locale getLocaleFromUnicode(byte[] unicodeBytes) {
        if (unicodeBytes.length == 2) {
            if (unicodeBytes[0] == 6 && unicodeBytes[1] >= 0 && unicodeBytes[1] <= 255) {
                return PDFFontSet.ARABIC;
            }
            if (unicodeBytes[0] == 5 && unicodeBytes[1] >= 144 && unicodeBytes[1] <= 255) {
                return PDFFontSet.HEBREW;
            }
            if (unicodeBytes[0] == 14 && unicodeBytes[1] >= 0 && unicodeBytes[1] <= 127) {
                return PDFFontSet.THAI;
            }
        }
        return null;
    }

    public static PDFFont createFontForEditting(PDFDocument pdfDoc, String fontName, boolean embedFont, boolean opentypeOK) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        PostscriptFontDescription fontDescription = new PostscriptFontDescription(fontName);
        PDFFontSetImpl fontset = (PDFFontSetImpl)pdfDoc.getCosDocument().getOptions().getFontSet();
        Font afeFont = null;
        if (fontset != null) {
            afeFont = fontset.getPSFont(fontDescription, PDFDocument.ROOT_LOCALE, false);
        }
        try {
            return PDFFontUtils.createFontForEditing(pdfDoc, afeFont, embedFont, opentypeOK);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static PDFFont createFontForEditing(PDFDocument pdfDoc, Font afeFont, boolean embedFont, boolean opentypeOK) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (afeFont == null) {
            return null;
        }
        try {
            PDFFont theFont = afeFont.getPDFFontDescription().getROS() != null ? PDFFontUtils.createCompositeFont(pdfDoc, afeFont, embedFont, opentypeOK) : PDFFontUtils.createSimpleFont(pdfDoc, afeFont, embedFont, opentypeOK);
            return theFont;
        }
        catch (FontEngineException e) {
            throw new PDFFontException(e);
        }
    }

    public static PDFFont createFontForEditing(PDFDocument pdfDoc, String typeFace, String posture, String weight, double pointSize, Locale locale, boolean embedFont, boolean opentypeOK) throws FontException, PDFFontException, PDFConfigurationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        Font afeFont = PDFFontUtils.doCSSLookup(pdfDoc, typeFace, posture, weight, pointSize, locale);
        PDFFont pdfFontToAdd = PDFFontUtils.createFontForEditing(pdfDoc, afeFont, embedFont, opentypeOK);
        return pdfFontToAdd;
    }

    private static Font doCSSLookup(PDFDocument pdfDoc, String typeFace, String posture, String weight, double pointSize, Locale locale) throws FontException, PDFFontException, PDFConfigurationException {
        CSS20FontSet cssFontSet = null;
        PDFFontSetImpl pdfFontSet = PDFFontUtils.determineFallbackFontSet(pdfDoc);
        if (pdfFontSet != null) {
            cssFontSet = pdfFontSet.getCSS20FontSet();
            cssFontSet.setFallbackFonts(pdfFontSet.getFallbackFontSet());
        }
        if (cssFontSet == null) {
            throw new PDFConfigurationException("Null CSS Fontset encountered");
        }
        cssFontSet.setResolutionPriority(FontResolutionPriority.INTELLIGENT);
        CSS20Attribute att = new CSS20Attribute(new String[]{typeFace}, CSS20Attribute.CSSStyleValue.parse(posture), CSS20Attribute.CSSVariantValue.NORMAL, CSS20Attribute.CSSStretchValue.NORMAL, CSS20Attribute.CSSWeightValue.parse(weight), pointSize);
        return cssFontSet.findFont(att, ULocale.forLocale(locale));
    }

    private static PDFFontSetImpl determineFallbackFontSet(PDFDocument pdfDoc) throws PDFConfigurationException {
        PDFFontSet pdfFontSet = pdfDoc.getCosDocument().getOptions().getFontSet();
        if (pdfFontSet == null) {
            throw new PDFConfigurationException("Fontset not available via the Document Open Options");
        }
        return (PDFFontSetImpl)pdfFontSet;
    }

    private static PDFFont createSimpleFont(PDFDocument pdfDoc, Font afeFont, boolean embedFont, boolean opentypeOK) throws FontEngineException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        PDFFontFile fontFile;
        PDFFontDescription pdfDesc = afeFont.getPDFFontDescription();
        ASName baseFont = ASName.create(pdfDesc.getPostscriptName());
        PDFFontSimple simpleFont = PDFFontSimple.newInstance(pdfDoc, baseFont, pdfDesc.pdfFontIsTrueType() ? ASName.create("TrueType") : ASName.create("Type1"));
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(pdfDoc, baseFont, pdfDesc);
        if ((fontDescriptor.getFlags() & 0x20) != 0) {
            simpleFont.setEncoding(PDFSimpleFontEncoding.newInstance(pdfDoc, ASName.k_WinAnsiEncoding));
        }
        if (embedFont && (fontFile = PDFFontFile.newInstance(pdfDoc, opentypeOK, afeFont)) != null) {
            PDFFilterFlate filter = PDFFilterFlate.newInstance(pdfDoc, null);
            fontFile.setFilter(filter);
            if (pdfDesc.pdfFontIsTrueType()) {
                fontDescriptor.setFontFile2(fontFile);
            } else {
                try {
                    fontFile.setEmbeddedFontType(opentypeOK ? PDFFontFile.EmbeddedFontType.OpenType : PDFFontFile.EmbeddedFontType.Type1C);
                }
                catch (PDFInvalidParameterException e) {
                    // empty catch block
                }
                fontDescriptor.setFontFile3(fontFile);
            }
        }
        simpleFont.setFontDescriptor(fontDescriptor);
        simpleFont.resetAFEFont();
        simpleFont.buildWidths(32, 255, afeFont);
        return simpleFont;
    }

    private static PDFFont createCompositeFont(PDFDocument pdfDoc, Font afeFont, boolean embedFont, boolean opentypeOK) throws FontEngineException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        PDFFontFile fontFile;
        PDFFontDescription pdfDesc = afeFont.getPDFFontDescription();
        ASName baseFont = ASName.create(pdfDesc.getPostscriptName());
        ROS ros = pdfDesc.getROS();
        if (ros == null) {
            ros = new ROS("Adobe", "Identity", 0);
        }
        PDFFontType0 compFont = (PDFFontType0)PDFFontType0.newInstance(pdfDoc, baseFont);
        compFont.setEncoding(PDFType0FontEncoding.newInstance(pdfDoc, ASName.create("UniJIS-UTF16-H")));
        PDFCIDFont cidFont = PDFCIDFont.newInstance(pdfDoc, baseFont, ASName.k_CIDFontType0);
        compFont.setDescendantFont(cidFont);
        cidFont.setCIDSystemInfo(PDFCIDSystemInfo.newInstance(pdfDoc, new ASString(ros.registry), new ASString(ros.ordering), ros.supplement));
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(pdfDoc, baseFont, pdfDesc);
        cidFont.setFontDescriptor(fontDescriptor);
        if (embedFont && (fontFile = PDFFontFile.newInstance(pdfDoc, opentypeOK, afeFont)) != null) {
            try {
                fontFile.setEmbeddedFontType(opentypeOK ? PDFFontFile.EmbeddedFontType.OpenType : PDFFontFile.EmbeddedFontType.CIDFontType0C);
            }
            catch (PDFInvalidParameterException e) {
                // empty catch block
            }
            PDFFilterFlate filter = PDFFilterFlate.newInstance(pdfDoc, null);
            fontFile.setFilter(filter);
            fontDescriptor.setFontFile3(fontFile);
        }
        PDFCIDFontWidths cidFontWidths = PDFCIDFontWidths.newInstance(pdfDoc);
        cidFontWidths.buildWidths(new GlyphIterator(pdfDesc.getNumGlyphs()), pdfDesc, 1000.0);
        cidFont.setW(cidFontWidths);
        return compFont;
    }

    public static PDFFontFile getFontFileFromFontDescriptor(PDFFontDescriptor pdfFontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfFontDescriptor == null) {
            return null;
        }
        PDFFontFile fontFile = pdfFontDescriptor.getFontFile();
        if (fontFile == null) {
            fontFile = pdfFontDescriptor.getFontFile2();
        }
        if (fontFile == null) {
            fontFile = pdfFontDescriptor.getFontFile3();
        }
        return fontFile;
    }

    public static PDFFontDescriptor getPDFFontDescriptor(PDFFont pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfFont instanceof PDFFontType0) {
            return ((PDFFontType0)pdfFont).getDescendantFont().getFontDescriptor();
        }
        if (pdfFont instanceof PDFFontSimple) {
            return ((PDFFontSimple)pdfFont).getFontDescriptor();
        }
        return null;
    }

    public static boolean isFontDataTrueType(FontData fontData) {
        return fontData instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() == null;
    }

    public static boolean isCMapIdentity(PDFType0FontEncoding cMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isCMapIdentity = false;
        if (cMap.isPredefinedCMap()) {
            ASName cMapName = cMap.getCMapName();
            isCMapIdentity = cMapName == ASName.k_Identity_H || cMapName == ASName.k_Identity_V;
        }
        return isCMapIdentity;
    }

    public static boolean setWModeInEmbeddedCMap(PDFFontType0 type0Font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFType0FontEncoding cMap = type0Font.getEncoding();
        if (cMap.getCosObject().getType() == 7) {
            PDFWritingMode cMapStreamWMode = CMapResourceBuilder.getWMode(cMap.getCosStream());
            CosStream cmapObj = (CosStream)cMap.getCosObject();
            cmapObj.put(ASName.k_WMode, cMapStreamWMode.equals((Object)PDFWritingMode.VERTICAL) ? 1 : 0);
            return true;
        }
        return false;
    }

    public static boolean isFontEmbedded(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontFile file;
        if (font instanceof PDFFontType3) {
            return true;
        }
        PDFFontDescriptor fdesc = font.getFontDescriptor();
        return fdesc != null && (file = PDFFontUtils.getFontFileFromFontDescriptor(fdesc)) != null;
    }

    public static boolean isSubsetFontName(String baseFontName) {
        if (baseFontName == null) {
            return false;
        }
        if (baseFontName.length() < 8) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Character.isUpperCase(baseFontName.charAt(i))) continue;
            return false;
        }
        return baseFontName.charAt(6) == '+';
    }

    public static boolean isSubsetFont(PDFFont font) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        String fontName = PDFFontUtils.getBaseFontName(font);
        if (fontName == null) {
            return false;
        }
        return PDFFontUtils.isSubsetFontName(fontName);
    }

    public static String getActualBaseFontName(PDFFont font) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        String baseFontName = PDFFontUtils.getBaseFontName(font);
        if (baseFontName != null) {
            if (PDFFontUtils.isSubsetFontName(baseFontName)) {
                return baseFontName.substring(7);
            }
            return baseFontName;
        }
        return null;
    }

    private static String getBaseFontName(PDFFont font) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        String fontName;
        if (font == null) {
            return null;
        }
        if (font instanceof PDFFontType0) {
            PDFFontType0 type0Font = (PDFFontType0)font;
            PDFCIDFont cidFont = type0Font.getDescendantFont();
            fontName = cidFont.getBaseFont().asString();
        } else {
            ASName asname = font.getBaseFont();
            if (asname == null) {
                return null;
            }
            fontName = asname.asString();
        }
        return fontName;
    }

    public static boolean isOpenTypeFontEmbedded(PDFFont font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName ffType;
        PDFFontFile ffile;
        if (font == null) {
            return false;
        }
        PDFFontDescriptor fdesc = font.getFontDescriptor();
        return fdesc != null && (ffile = fdesc.getFontFile3()) != null && (ffType = ffile.getSubtype()) == ASName.create("OpenType");
    }

    public static boolean isGlyphNotDef(PDFFont font, int charcode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        int gid = font.charCode2gid(charcode);
        Font afeFont = font.getAFEFont();
        if (afeFont == null) {
            return false;
        }
        PDFFontDescription desc = afeFont.getPDFFontDescription();
        if (desc == null) {
            return false;
        }
        if (font instanceof PDFFontType0) {
            return gid == -1;
        }
        if (gid < 0) {
            return true;
        }
        return ".notdef".equals(desc.getGlyphName(gid));
    }

    public static ASName generateSubsetFontName(Object fontSubset, String basefontName) {
        try {
            ASName subsetfontName = ASName.create(basefontName);
            if (!PDFFontUtils.isSubsetFontName(basefontName)) {
                int iCode = fontSubset.hashCode() > 0 ? fontSubset.hashCode() : -fontSubset.hashCode();
                int A = 65;
                byte[] tag = new byte[7];
                for (int j = 0; j < 6; ++j) {
                    tag[j] = (byte)(A + iCode % 26);
                    iCode /= 26;
                }
                tag[6] = 43;
                String subsetFontTag = new String(tag, "US-ASCII");
                subsetfontName = ASName.create(subsetFontTag + basefontName);
            }
            return subsetfontName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported.", e);
        }
    }

    public static PDFCIDFont createPDFCIDFont(PDFFontFile fontFile, PDFFontType0 font, PDFFontDescription afeFontDesc, int dw, PDFCIDFontWidths pdfCIDFontWidths, ASName subsetFontName, PDFFontDescriptor fontDescriptor) throws UnsupportedFontException, InvalidFontException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFCIDFont cidFont;
        PDFDocument pdfDocument = fontFile.getPDFDocument();
        if (!afeFontDesc.pdfFontIsTrueType()) {
            try {
                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.CIDFontType0C);
            }
            catch (PDFInvalidParameterException e) {
                // empty catch block
            }
            fontDescriptor.setFontFile3(fontFile);
            cidFont = PDFCIDFont.newInstance(pdfDocument, subsetFontName, ASName.k_CIDFontType0);
        } else {
            fontDescriptor.setFontFile2(fontFile);
            cidFont = PDFCIDFont.newInstance(pdfDocument, subsetFontName, ASName.k_CIDFontType2);
        }
        cidFont.setDW(dw);
        if (pdfCIDFontWidths != null) {
            cidFont.setW(pdfCIDFontWidths);
        }
        cidFont.setFontDescriptor(fontDescriptor);
        return cidFont;
    }

    public static PDFFontDescriptor generatePDFFontDescriptor(PDFFont font, PDFFontDescription afeFontDesc) throws PDFIOException, PDFSecurityException, UnsupportedFontException, PDFInvalidDocumentException, InvalidFontException {
        PDFFontDescriptor fontDesc;
        PDFFontSimple simpleFont;
        ASName baseFont;
        if (font instanceof PDFFontSimple && PDFFontUtils.isStandardFont(baseFont = (simpleFont = (PDFFontSimple)font).getBaseFont()) && (fontDesc = PDFFontSimple.getStandardFontFontDescriptor(baseFont)) != null) {
            PDFCosFontDescriptor pdfCosDesc = fontDesc.getPDFCosDescriptor();
            CosObject fontDescCosObj = null;
            if (pdfCosDesc != null) {
                fontDescCosObj = fontDesc.getPDFCosDescriptor().getCosObject();
            } else {
                ASDictionary fontDescMap = fontDesc.getPDFDictDescriptor();
                CosDocument cosDoc = font.getPDFDocument().getCosDocument();
                if (fontDescMap != null) {
                    LinkedHashMap<ASName, CosNumeric> newFontDescMap = new LinkedHashMap<ASName, CosNumeric>();
                    for (Map.Entry entry : fontDescMap.entrySet()) {
                        ASName key = (ASName)entry.getKey();
                        Object value = entry.getValue();
                        CosObject valueObj = null;
                        if (value instanceof ASNumber) {
                            valueObj = cosDoc.createCosNumeric(((ASNumber)value).numberValue());
                        } else if (value instanceof ASRectangle) {
                            double[] val = ((ASRectangle)value).getValues();
                            valueObj = cosDoc.createCosArray();
                            for (int i = 0; i < val.length; ++i) {
                                ((CosArray)valueObj).add(i, cosDoc.createCosNumeric(val[i]));
                            }
                        } else if (value instanceof ASName) {
                            valueObj = cosDoc.createCosName((ASName)value);
                        }
                        if (value instanceof String) {
                            valueObj = cosDoc.createCosString((String)value);
                        }
                        newFontDescMap.put(key, (CosNumeric)valueObj);
                    }
                    fontDescCosObj = font.getPDFDocument().getCosDocument().createCosDictionary(newFontDescMap);
                }
            }
            if (fontDescCosObj != null) {
                return PDFFontDescriptor.getInstance(fontDescCosObj);
            }
        }
        PDFFontDescriptor fontDescriptor = null;
        PDFFontDescriptor oldFontDesc = font.getFontDescriptor();
        if (oldFontDesc != null) {
            fontDescriptor = PDFFontDescriptor.newInstance(oldFontDesc, font.getPDFDocument());
        } else {
            int flags = 0;
            FontData afeFontData = font.getAFEFontData();
            if (afeFontDesc.isAllCapFont()) {
                flags &= 0x10000;
            }
            if (afeFontDesc.isSerifFont()) {
                flags &= 2;
            }
            if (afeFontDesc.isSmallCapFont()) {
                flags &= 0x20000;
            }
            if (!afeFontData.getCoolTypeProportionalRomanFromFontProperties()) {
                flags &= 1;
            }
            if (!afeFontData.isSymbolic()) {
                flags &= 0x20;
            }
            fontDescriptor = PDFFontDescriptor.newInstance(font.getPDFDocument(), null, afeFontDesc, flags);
        }
        return fontDescriptor;
    }

    public static int getSimpleFontGidFromCharCode(int charCode, String glyphName, PDFSimpleFontEncoding encoding, FontData fontData, PDFFontDescriptor fontDescriptor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        try {
            if (fontData instanceof Type1Font) {
                Type1Font t1Font = (Type1Font)fontData;
                if (glyphName != null) {
                    return t1Font.glyphName2gid(glyphName);
                }
                return t1Font.charCode2gid(charCode);
            }
            if (fontData instanceof NameKeyedFont) {
                NameKeyedFont nameKeyedFont = (NameKeyedFont)fontData;
                if (glyphName != null) {
                    return nameKeyedFont.glyphName2gid(glyphName);
                }
                return nameKeyedFont.charCode2gid(charCode);
            }
            if (fontData instanceof OpenTypeFont) {
                if (((OpenTypeFont)fontData).getCFFFont() != null) {
                    if ((fontData = ((OpenTypeFont)fontData).getCFFFont()) instanceof NameKeyedFont) {
                        NameKeyedFont nameKeyedFont = (NameKeyedFont)fontData;
                        if (glyphName != null) {
                            return nameKeyedFont.glyphName2gid(glyphName);
                        }
                        return nameKeyedFont.charCode2gid(charCode);
                    }
                } else {
                    OpenTypeFont otFont = (OpenTypeFont)fontData;
                    if (encoding == null || fontDescriptor != null && (fontDescriptor.getFlags() & 4) != 0) {
                        if (otFont.cmap != null) {
                            int threeZeroOffset = otFont.cmap.probe(3, 0);
                            if (threeZeroOffset != -1) {
                                int gid = otFont.cmap.getMapping(threeZeroOffset, charCode);
                                if (gid != 0) {
                                    return gid;
                                }
                                gid = otFont.cmap.getMapping(threeZeroOffset, 61440 + charCode);
                                if (gid != 0) {
                                    return gid;
                                }
                                gid = otFont.cmap.getMapping(threeZeroOffset, 61696 + charCode);
                                if (gid != 0) {
                                    return gid;
                                }
                                gid = otFont.cmap.getMapping(threeZeroOffset, 61952 + charCode);
                                if (gid != 0) {
                                    return gid;
                                }
                                return 0;
                            }
                            int oneZeroOffset = otFont.cmap.probe(1, 0);
                            if (oneZeroOffset != -1) {
                                return otFont.cmap.getMapping(oneZeroOffset, charCode);
                            }
                        }
                        return 0;
                    }
                    if ((encoding.isMacRomanEncoding() || encoding.isWinAnsiEncoding() || fontDescriptor != null) && (fontDescriptor.getFlags() & 0x20) != 0) {
                        glyphName = encoding.getGlyphName(charCode);
                        if (glyphName == null && !encoding.isMacRomanEncoding() && !encoding.isWinAnsiEncoding()) {
                            glyphName = StandardEncoding.getEncoding().getGlyphName(charCode);
                        }
                        if (glyphName == null) {
                            return 0;
                        }
                        if (otFont.cmap != null) {
                            int threeOneOffset = otFont.cmap.probe(3, 1);
                            if (threeOneOffset != -1) {
                                int[] usvs = GlyphNames.resolveAGNCNameIntoArray(glyphName, false);
                                if (usvs.length == 1) {
                                    return otFont.cmap.getMapping(threeOneOffset, usvs[0]);
                                }
                                if (otFont.post != null) {
                                    return otFont.post.glyphName2gid(glyphName);
                                }
                                return 0;
                            }
                            int oneZeroOffset = otFont.cmap.probe(1, 0);
                            if (oneZeroOffset != -1) {
                                for (int i = 0; i < 256; ++i) {
                                    if (!glyphName.equals(MacRomanEncoding.getGlyphNameInAugmentedMacRomanEncoding(i))) continue;
                                    return otFont.cmap.getMapping(oneZeroOffset, i);
                                }
                            }
                            if (otFont.post != null) {
                                return otFont.post.glyphName2gid(glyphName);
                            }
                            return 0;
                        }
                        return 0;
                    }
                }
                return 0;
            }
            return 0;
        }
        catch (FontEngineException e) {
            throw new PDFFontException(e);
        }
    }

    public static double[] getGlyphWidth(boolean defaultMissingWidth, PDFFontSimple fontSimple, int ... charCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] widths;
        block6: {
            int lastChar;
            int firstChar;
            double missingWidth;
            block5: {
                widths = new double[charCodes.length];
                missingWidth = -1.0;
                CosArray widthsArray = fontSimple.getCosDictionary().getCosArray(ASName.k_Widths);
                firstChar = fontSimple.getFirstChar();
                lastChar = fontSimple.getLastChar();
                if (widthsArray == null) break block5;
                double commonWidth = widthsArray.size() == 1 ? widthsArray.getDouble(0) : -1.0;
                for (int i = 0; i < charCodes.length; ++i) {
                    if (charCodes[i] >= firstChar && charCodes[i] <= lastChar && charCodes[i] - firstChar < widthsArray.size()) {
                        if (commonWidth >= 0.0) {
                            widths[i] = commonWidth;
                            continue;
                        }
                        widths[i] = widthsArray.getDouble(charCodes[i] - firstChar);
                        continue;
                    }
                    missingWidth = PDFFontUtils.getWidthForOutOfRangeCharCode(defaultMissingWidth, fontSimple, widths, missingWidth, i, charCodes);
                }
                break block6;
            }
            if (!PDFFontUtils.isStandardFont(fontSimple.getBaseFont())) break block6;
            int[] standardWidths = fontSimple.getStandardFontWidths();
            for (int i = 0; i < charCodes.length; ++i) {
                if (charCodes[i] >= firstChar && charCodes[i] <= lastChar) {
                    widths[i] = standardWidths.length == 1 ? (double)standardWidths[0] : (double)standardWidths[charCodes[i]];
                    if (widths[i] != 0.0) continue;
                    widths[i] = PDFFontUtils.getGlyphWidthFromEmbeddedFontFile(charCodes[i], fontSimple);
                    continue;
                }
                missingWidth = PDFFontUtils.getWidthForOutOfRangeCharCode(defaultMissingWidth, fontSimple, widths, missingWidth, i, charCodes);
            }
        }
        return widths;
    }

    private static double getWidthForOutOfRangeCharCode(boolean defaultMissingWidth, PDFFontSimple fontSimple, double[] widths, double missingWidth, int charCodeIndex, int ... charCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (defaultMissingWidth) {
            PDFFontDescriptor fontDescr;
            if (missingWidth < 0.0 && (fontDescr = fontSimple.getFontDescriptor()) != null) {
                missingWidth = fontDescr.getMissingWidth();
            }
            widths[charCodeIndex] = missingWidth;
        } else {
            widths[charCodeIndex] = PDFFontUtils.getGlyphWidthFromEmbeddedFontFile(charCodes[charCodeIndex], fontSimple);
        }
        return missingWidth;
    }

    public static boolean isStandardFont(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return StandardFontUtils.standardFontsNames.containsKey(fontName);
    }

    public static int charCode2gid(int charCode, PDFFontType0 pdfFont, FontData fontData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        try {
            if (fontData instanceof OpenTypeFont) {
                PDFCIDFont descendantFont = pdfFont.getDescendantFont();
                int numGlyphs = fontData.getNumGlyphs();
                if (((OpenTypeFont)fontData).getCFFFont() instanceof CIDKeyedFont) {
                    PDFType0FontEncoding encoding = pdfFont.getEncoding();
                    int cid = encoding.getCID(charCode);
                    return ((CIDKeyedFont)((OpenTypeFont)fontData).getCFFFont()).cid2gid(cid);
                }
                if (((OpenTypeFont)fontData).getCFFFont() instanceof NameKeyedFont) {
                    return ((NameKeyedFont)((OpenTypeFont)fontData).getCFFFont()).charCode2gid(charCode);
                }
                if (descendantFont.getSubType() == ASName.k_CIDFontType2) {
                    if (descendantFont.getFontDescriptor() != null && descendantFont.getFontDescriptor().containsEmbeddedFont()) {
                        PDFType0FontEncoding encoding = pdfFont.getEncoding();
                        int cid = encoding.getCID(charCode);
                        int gid = descendantFont.cid2gid(cid);
                        if (numGlyphs <= gid) {
                            return -1;
                        }
                        return gid;
                    }
                    return PDFFontUtils.charCode2gidForUnembeddedCIDType2(charCode, pdfFont, (OpenTypeFont)fontData, fontData.getCoolTypeScript().toInt());
                }
                if (descendantFont.getSubType() == ASName.k_CIDFontType0) {
                    return ((OpenTypeFont)fontData).cmap.unicodeChar2glyph(charCode);
                }
            } else if (fontData instanceof CIDKeyedFont) {
                PDFType0FontEncoding encoding = pdfFont.getEncoding();
                int cid = encoding.getCID(charCode);
                return ((CIDKeyedFont)fontData).cid2gid(cid);
            }
            return charCode;
        }
        catch (FontEngineException e) {
            throw new PDFFontException(e);
        }
    }

    public static int getMinCharCodeBytes(PDFFontType0 font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFType0FontEncoding fontEnc = font.getEncoding();
        PDFCMap pdfCMap = fontEnc != null ? fontEnc.getPDFCMap() : null;
        return pdfCMap == null ? 2 : pdfCMap.getMinBytesNeeded();
    }

    private static int charCode2gidForUnembeddedCIDType2(int charCode, PDFFontType0 pdfFont, OpenTypeFont otFont, int script) throws UnsupportedFontException, InvalidFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Cmap cmapTable = otFont.cmap;
        if (cmapTable != null) {
            FontType2CmapSelector selector = new FontType2CmapSelector(script);
            cmapTable.enumerateCmaps(selector);
            int offset = cmapTable.getOffset(selector.getSelectedCmapIndex());
            if (selector.selectedUnicodeCmap()) {
                List vals;
                try {
                    vals = (List)pdfFont.getCharCodes(PDFCMapUtils.numToByteArray(charCode, PDFFontUtils.getMinCharCodeBytes(pdfFont)), true).get(0);
                }
                catch (Exception e) {
                    return cmapTable.getMapping(offset, charCode);
                }
                int[] unicode = (int[])vals.get(1);
                if (unicode != null && unicode.length > 0) {
                    return cmapTable.getMapping(offset, unicode[0]);
                }
            } else {
                return cmapTable.getMapping(offset, charCode);
            }
        }
        return 0;
    }

    public static List getCharCodes(byte[] bytes, boolean fetchUnicode, boolean validateCharCodeToCIDMapping, PDFFontType0 pdfFont, boolean ignoreByteLengthError) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFType0FontEncoding fontEnc = pdfFont.getEncoding();
        PDFCMap pdfCMap = null;
        ASName cmapName = fontEnc.getCMapName();
        int bytePos = 0;
        ArrayList charCodes = new ArrayList();
        byte[] charCodeBytes = null;
        boolean found = false;
        int minBytesNeeded = 1;
        int byteCount = 0;
        int maxBytesAllowed = 1;
        if (cmapName == ASName.k_Identity_H || cmapName == ASName.k_Identity_V) {
            int maxIndex = bytes.length;
            if (bytes.length % 2 > 0) {
                if (ignoreByteLengthError) {
                    --maxIndex;
                } else {
                    throw new PDFInvalidDocumentException("Number of bytes needed for identity CMap is multiple of 2");
                }
            }
            for (int i = 0; i < maxIndex; i += 2) {
                charCodeBytes = new byte[]{bytes[i], bytes[i + 1]};
                int[] unicodes = null;
                if (fetchUnicode) {
                    long cid = PDFCMapUtils.getCharCode(charCodeBytes);
                    PDFToUnicodeCMap toUnicodeCMap = pdfFont.getToUnicodeCMap();
                    if (toUnicodeCMap == null) {
                        PDFCIDSystemInfo sysInfo = pdfFont.getDescendantFont().getCIDSystemInfo();
                        if (pdfCMap == null) {
                            pdfCMap = fontEnc.getPDFCMap();
                        }
                        if ((unicodes = pdfCMap.getUnicodeIdentity(sysInfo.getRegistry().toString(), sysInfo.getOrdering().toString(), charCodeBytes)) == null) {
                            throw new PDFInvalidDocumentException("Could not fond unicode values for charcodes " + cmapName.asString());
                        }
                    } else {
                        char[] unicodeChars = toUnicodeCMap.toUnicode((int)cid);
                        unicodes = new int[unicodeChars.length];
                        for (int iUnicode = 0; iUnicode < unicodeChars.length; ++iUnicode) {
                            unicodes[iUnicode] = unicodeChars[iUnicode];
                        }
                    }
                }
                ArrayList<int[]> charCodeWithUnicode = new ArrayList<int[]>(2);
                charCodeWithUnicode.add(charCodeBytes);
                if (fetchUnicode) {
                    charCodeWithUnicode.add(unicodes);
                }
                charCodes.add(charCodeWithUnicode);
            }
            return charCodes;
        }
        if (pdfCMap == null) {
            pdfCMap = fontEnc.getPDFCMap();
        }
        minBytesNeeded = pdfCMap.getMinBytesNeeded();
        maxBytesAllowed = pdfCMap.getMaxBytesAllowed();
        byteCount = minBytesNeeded;
        while (bytePos < bytes.length) {
            int cid;
            charCodeBytes = new byte[byteCount];
            int posToshift = 0;
            for (int iByte = 0; iByte < byteCount; ++iByte) {
                if (bytePos + iByte >= bytes.length) {
                    ++posToshift;
                    continue;
                }
                charCodeBytes[iByte] = bytes[bytePos + iByte];
            }
            if (posToshift != 0) {
                PDFFontUtils.shiftArrayContentsToRight(charCodeBytes, posToshift);
            }
            if (fetchUnicode) {
                int[] unicodes = null;
                PDFToUnicodeCMap toUnicodeCMap = pdfFont.getToUnicodeCMap();
                if (toUnicodeCMap == null) {
                    unicodes = pdfCMap.getUnicode(charCodeBytes);
                } else {
                    char[] unicodeChars = toUnicodeCMap.toUnicode((int)PDFCMapUtils.getCharCode(charCodeBytes));
                    unicodes = new int[unicodeChars.length];
                    for (int iUnicode = 0; iUnicode < unicodeChars.length; ++iUnicode) {
                        unicodes[iUnicode] = Character.codePointAt(unicodeChars, iUnicode);
                    }
                }
                if (unicodes != null) {
                    int cid2;
                    if (validateCharCodeToCIDMapping && (cid2 = pdfCMap.getCID(charCodeBytes)) == -1) {
                        found = false;
                        if (++byteCount <= bytes.length && byteCount <= maxBytesAllowed) continue;
                        break;
                    }
                    bytePos += byteCount;
                    ArrayList<int[]> charCodeWithUnicode = new ArrayList<int[]>();
                    charCodeWithUnicode.add(charCodeBytes);
                    charCodeWithUnicode.add(unicodes);
                    charCodes.add(charCodeWithUnicode);
                    byteCount = minBytesNeeded;
                    found = true;
                    continue;
                }
                found = false;
                if (++byteCount <= bytes.length && byteCount <= maxBytesAllowed) continue;
                break;
            }
            if (validateCharCodeToCIDMapping && (cid = pdfCMap.getCID(charCodeBytes)) == -1) {
                if (++byteCount <= bytes.length && byteCount <= maxBytesAllowed) continue;
                byteCount = minBytesNeeded;
                StringBuilder glyphNotFoundErrorMsgBuilder = new StringBuilder("ERROR!!! Unable to find Glyph for character code bytes [");
                for (int i = 0; i < charCodeBytes.length - 1; ++i) {
                    glyphNotFoundErrorMsgBuilder.append(charCodeBytes[i]).append(", ");
                }
                glyphNotFoundErrorMsgBuilder.append(charCodeBytes[charCodeBytes.length - 1]).append("]");
                glyphNotFoundErrorMsgBuilder.append(". Skipping this character.");
                System.out.println(glyphNotFoundErrorMsgBuilder.toString());
                charCodeBytes = null;
            }
            bytePos += byteCount;
            ArrayList<byte[]> charCodeWithUnicode = new ArrayList<byte[]>();
            charCodeWithUnicode.add(charCodeBytes);
            charCodes.add(charCodeWithUnicode);
            byteCount = minBytesNeeded;
            found = true;
        }
        if (!found) {
            PDFFontUtils.throwError(cmapName, bytes, bytePos, --byteCount);
        }
        return charCodes;
    }

    private static void throwError(ASName cmapName, byte[] bytes, int bytePos, int byteCount) throws PDFInvalidDocumentException {
        StringBuilder errMsg = new StringBuilder("Bytes ");
        int i = bytePos;
        for (int j = 0; j < byteCount && i < bytes.length; ++i, ++j) {
            errMsg.append(bytes[i]).append(' ');
        }
        errMsg.append(" is not defined in CMap ").append(cmapName.asString());
        throw new PDFInvalidDocumentException(errMsg.toString());
    }

    private static void shiftArrayContentsToRight(byte[] array, int posToShift) {
        if (array.length <= 1 || posToShift > array.length) {
            return;
        }
        for (int i = array.length - 1; i >= 0; --i) {
            array[i] = i >= posToShift ? array[i - posToShift] : (byte)0;
        }
    }

    public static OpenTypeCmapSubTableType getOpenTypeCmapSubTableType(PDFFontSimple font) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSimpleFontEncoding encoding = font.getEncoding();
        PDFFontDescriptor fontDescriptor = font.getFontDescriptor();
        if (encoding == null || fontDescriptor != null && (fontDescriptor.getFlags() & 4) != 0) {
            return OpenTypeCmapSubTableType.ThreeZero;
        }
        if (encoding.isMacRomanEncoding() || encoding.isWinAnsiEncoding() || fontDescriptor != null && (fontDescriptor.getFlags() & 0x20) != 0) {
            return OpenTypeCmapSubTableType.ThreeOne;
        }
        return null;
    }

    public static int charCode2CodePoint(int charCode, PDFFontSimple pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException {
        FontData fontData = pdfFont.getAFEFontData();
        if (fontData == null) {
            return 0;
        }
        if (fontData instanceof OpenTypeFont) {
            OpenTypeFont otFont = (OpenTypeFont)fontData;
            OpenTypeCmapSubTableType openTypeCmapSubTableType = PDFFontUtils.getOpenTypeCmapSubTableType(pdfFont);
            if (openTypeCmapSubTableType == OpenTypeCmapSubTableType.ThreeZero) {
                if (otFont.cmap != null) {
                    int threeZeroOffset = otFont.cmap.probe(3, 0);
                    if (threeZeroOffset != -1) {
                        if (otFont.cmap.getMapping(threeZeroOffset, charCode) != 0) {
                            return charCode;
                        }
                        if (otFont.cmap.getMapping(threeZeroOffset, 61440 + charCode) != 0) {
                            return 61440 + charCode;
                        }
                        if (otFont.cmap.getMapping(threeZeroOffset, 61696 + charCode) != 0) {
                            return 61696 + charCode;
                        }
                        if (otFont.cmap.getMapping(threeZeroOffset, 61952 + charCode) != 0) {
                            return 61952 + charCode;
                        }
                        return 0;
                    }
                    int oneZeroOffset = otFont.cmap.probe(1, 0);
                    if (oneZeroOffset != -1) {
                        return charCode;
                    }
                }
                return 0;
            }
            if (openTypeCmapSubTableType == OpenTypeCmapSubTableType.ThreeOne) {
                PDFSimpleFontEncoding encoding = pdfFont.getEncoding();
                String glyphName = encoding.getGlyphName(charCode);
                if (glyphName == null && !encoding.isMacRomanEncoding() && !encoding.isWinAnsiEncoding()) {
                    glyphName = StandardEncoding.getEncoding().getGlyphName(charCode);
                }
                if (glyphName == null) {
                    return 0;
                }
                if (otFont.cmap != null) {
                    int threeOneOffset = otFont.cmap.probe(3, 1);
                    if (threeOneOffset != -1) {
                        int[] usvs = GlyphNames.resolveAGNCNameIntoArray(glyphName, false);
                        if (usvs.length == 1) {
                            return usvs[0];
                        }
                        return 0;
                    }
                    int oneZeroOffset = otFont.cmap.probe(1, 0);
                    if (oneZeroOffset != -1) {
                        for (int i = 0; i < 256; ++i) {
                            if (!glyphName.equals(MacRomanEncoding.getGlyphNameInAugmentedMacRomanEncoding(i))) continue;
                            return i;
                        }
                        return 0;
                    }
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String charCode2glyphName(int charCode, PDFFontSimple pdfFont, FontData fontData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        if (fontData == null) {
            return null;
        }
        String glyphName = null;
        PDFSimpleFontEncoding encoding = pdfFont.getEncoding();
        if (fontData instanceof Type1Font || fontData instanceof NameKeyedFont || fontData instanceof OpenTypeFont && ((OpenTypeFont)fontData).getCFFFont() != null) {
            glyphName = encoding != null ? encoding.getGlyphName(charCode, pdfFont.getBaseFont(), PDFFontUtils.isFontEmbedded(pdfFont)) : pdfFont.getGlyphNameFromImplicitBaseEncoding(charCode);
        }
        if (glyphName != null) return glyphName;
        if (fontData instanceof Type1Font) {
            return ((Type1Font)fontData).charCode2GlyphName(charCode);
        }
        if (fontData instanceof NameKeyedFont) {
            try {
                int gid = ((NameKeyedFont)fontData).charCode2gid(charCode);
                if (gid <= 0) return glyphName;
                return ((NameKeyedFont)fontData).getGlyphName(gid);
            }
            catch (FontEngineException e) {
                throw new PDFFontException(e);
            }
        }
        if (!(fontData instanceof OpenTypeFont)) return glyphName;
        if (((OpenTypeFont)fontData).getCFFFont() == null) return glyphName;
        if (!((fontData = ((OpenTypeFont)fontData).getCFFFont()) instanceof NameKeyedFont)) return glyphName;
        try {
            int gid = ((NameKeyedFont)fontData).charCode2gid(charCode);
            if (gid < 0) return glyphName;
            return ((NameKeyedFont)fontData).getGlyphName(gid);
        }
        catch (FontEngineException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public static double getGlyphWidthFromEmbeddedFontFile(int charCode, PDFFontSimple pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double width = 0.0;
        try {
            FontData fdata;
            if (pdfFont.getBaseFont() != null && (fdata = pdfFont.getAFEFontData()) != null) {
                int glyphId = fdata.getGlyphForChar(charCode);
                width = fdata.getHorizontalAdvance(glyphId);
                double unitesPerEmX = fdata.getUnitsPerEmX();
                if (unitesPerEmX != 0.0) {
                    return width * 1000.0 / unitesPerEmX;
                }
            }
        }
        catch (InvalidFontException e) {
            throw new PDFIOException(e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFIOException(e);
        }
        return width;
    }

    public static enum OpenTypeCmapSubTableType {
        ThreeZero,
        ThreeOne;

    }

    private static class FontType2CmapSelector
    implements Cmap.CmapSelector {
        private boolean unicodeMSSelected = false;
        private int lastMScmap = -1;
        private int lastUnicmap = -1;
        private int lastMaccmap = -1;
        private final int writingScript;

        FontType2CmapSelector(int writingScript) {
            this.writingScript = writingScript;
        }

        @Override
        public void cmapFound(int platformID, int platformEncoding, int index) throws InvalidFontException, UnsupportedFontException {
            if (platformID == 3) {
                this.unicodeMSSelected = platformEncoding == 1 || platformEncoding == 10;
                this.lastMScmap = index;
            } else if (platformID == 0) {
                this.lastUnicmap = index;
            } else if (platformID == 1 && platformEncoding == this.writingScript) {
                this.lastMaccmap = index;
            }
        }

        int getSelectedCmapIndex() {
            if (this.lastMScmap != -1) {
                return this.lastMScmap;
            }
            if (this.lastUnicmap != -1) {
                return this.lastUnicmap;
            }
            return this.lastMaccmap;
        }

        boolean selectedUnicodeCmap() {
            if (this.lastMScmap != -1) {
                return this.unicodeMSSelected;
            }
            return this.lastUnicmap != -1;
        }
    }

    private static class GlyphDesc
    implements GlyphIDHolder {
        int gid;

        GlyphDesc(int gid) {
            this.gid = gid;
        }

        @Override
        public int getGlyphID() {
            return this.gid;
        }
    }

    private static class GlyphIterator
    implements Iterator {
        int numGlyphs;
        int currGlyph;

        GlyphIterator(int numGlyphs) {
            this.numGlyphs = numGlyphs;
            this.currGlyph = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currGlyph < this.numGlyphs;
        }

        public Object next() {
            return new GlyphDesc(this.currGlyph++);
        }

        @Override
        public void remove() {
        }
    }
}

