/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import java.util.ArrayList;

public class PDFOCUsageApp
extends PDFCosDictionary {
    private PDFOCUsageApp(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCUsageApp getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCUsageApp pdfObject = (PDFOCUsageApp)PDFCosObject.getCachedInstance(cosObject, PDFOCUsageApp.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCUsageApp(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCUsageApp newInstance(PDFDocument pdfDocument, ASName event, ArrayList categories) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCUsageApp usage = new PDFOCUsageApp(PDFCosObject.newCosDictionary(pdfDocument));
        if (!(event.equals(ASName.k_View) || event.equals(ASName.k_Print) || event.equals(ASName.k_Export))) {
            return null;
        }
        usage.setEvent(event);
        usage.setCategoryList(categories);
        usage.setOCGs(null);
        return usage;
    }

    public void setEventView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setEvent(ASName.k_View);
    }

    public void setEventPrint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setEvent(ASName.k_Print);
    }

    public void setEventExport() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setEvent(ASName.k_Export);
    }

    private void setEvent(ASName event) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Event, event);
    }

    public ASName getEvent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Event);
    }

    public void setOCGs(PDFOCGroupArray ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_OCGs, ocgs == null ? this.getPDFDocument().getCosDocument().createCosArray() : ocgs.getCosArray());
    }

    public PDFOCGroupArray getOCGs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject ocgs = this.getDictionaryCosObjectValue(ASName.k_OCGs);
        return PDFOCGroupArray.getInstance(ocgs);
    }

    public void setCategoryList(ArrayList<ASName> categories) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray catArray = PDFCosObject.newCosArray(this.getPDFDocument());
        for (ASName entry : categories) {
            catArray.addName(entry);
        }
        this.setDictionaryArrayValue(ASName.k_Category, catArray);
    }

    public ArrayList<ASName> getCategoryList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray entries = this.getDictionaryArrayValue(ASName.k_Category);
        if (entries != null) {
            int count = entries.size();
            ArrayList<ASName> result = new ArrayList<ASName>(count);
            for (int i = 0; i < count; ++i) {
                result.add(entries.getName(i));
            }
            return result;
        }
        return null;
    }
}

