/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;

public class PDFOCVExpression
extends PDFCosObject {
    private PDFOCVExpression(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCVExpression getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCVExpression pdfObject = (PDFOCVExpression)PDFCosObject.getCachedInstance(cosObject, PDFOCVExpression.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCVExpression(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCVExpression newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCVExpression(cosObject);
    }

    public static PDFOCVExpression newInstance(PDFDocument pdfDocument, ASName operator2, PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFOCVExpression pdfObject = new PDFOCVExpression(cosObject);
        cosObject.addName(0, operator2);
        cosObject.add(ocg.getCosObject());
        return pdfObject;
    }

    public void setOperatorAnd() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setOperator(ASName.k_And);
    }

    public void setOperatorOr() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setOperator(ASName.k_Or);
    }

    public void setOperatorNot() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setOperator(ASName.k_Not);
    }

    private void setOperator(ASName operator2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray obj = this.getCosArray();
        if (obj != null) {
            obj.addName(0, operator2);
        }
    }

    public ASName getOperator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject nameObj;
        ASName result = null;
        CosArray obj = this.getCosArray();
        if (obj != null && !obj.isEmpty() && (nameObj = obj.get(0)) instanceof CosName) {
            result = ((CosName)nameObj).nameValue();
        }
        return result;
    }

    public void addOCG(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray obj = this.getCosArray();
        if (obj != null) {
            obj.add(ocg.getCosObject());
        }
    }

    public void addOCGList(PDFOCGroupArray ocgList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray obj = this.getCosArray();
        if (obj != null) {
            for (PDFOCGroup elem : ocgList) {
                obj.add(elem.getCosObject());
            }
        }
    }

    public void addVExpression(PDFOCVExpression vExp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray obj = this.getCosArray();
        if (obj != null) {
            obj.add(vExp.getCosObject());
        }
    }
}

