/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.patterns;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;

public class PDFPatternFactory {
    public static PDFPattern getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        int subtype = 0;
        if (cosObject.getType() == 6) {
            CosDictionary cosPattern = (CosDictionary)cosObject;
            subtype = cosPattern.getInt(ASName.k_PatternType);
        } else if (cosObject.getType() == 7) {
            CosStream cosPattern = (CosStream)cosObject;
            subtype = cosPattern.getInt(ASName.k_PatternType);
        } else {
            throw new PDFInvalidDocumentException("Bad Pattern :- Expected Dictionary or Stream but found of Type" + cosObject.getType() + " Object Number " + cosObject.getObjNum());
        }
        if (subtype == 1) {
            return PDFPatternTiling.getInstance(cosObject);
        }
        if (subtype == 2) {
            return PDFPatternShading.getInstance(cosObject);
        }
        throw new PDFInvalidDocumentException("Bad Pattern");
    }
}

