/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingFactory;

public class PDFShadingMap
extends PDFCosDictionaryMap<PDFShading> {
    private PDFShadingMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFShadingMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFShadingMap pdfObject = (PDFShadingMap)PDFCosObject.getCachedInstance(cosObject, PDFShadingMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFShadingMap(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFShading itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFShadingFactory.getInstance(cosObject);
    }

    public static PDFShadingMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFShadingMap pdfObject = new PDFShadingMap(cosObject);
        return pdfObject;
    }

    public PDFShading get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFShading)super.get(name);
        }
        return null;
    }

    public void set(ASName name, PDFShading shading) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, shading.getPDFCosObject());
    }
}

