/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import java.util.ArrayList;

public abstract class PDFShadingNoMeshes
extends PDFCosDictionary
implements PDFShading {
    protected PDFShadingNoMeshes(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public PDFColorSpace getColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFColorSpaceFactory.getInstance(this.getCosDictionary().get(ASName.k_ColorSpace));
    }

    protected void setColorSpace(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Color Space is a required entry");
        }
        this.setDictionaryNameValue(ASName.k_ColorSpace, value);
    }

    protected void setColorSpace(PDFColorSpace children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("ColorSpace is a required key");
        }
        this.setDictionaryArrayValue(ASName.k_ColorSpace, children.getCosArray());
    }

    public PDFRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_BBox));
    }

    public void setBBox(PDFRectangle rect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (rect == null) {
            this.removeValue(ASName.k_BBox);
        } else {
            this.setDictionaryArrayValue(ASName.k_BBox, rect.getCosArray());
        }
    }

    public void setBBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Double> rectArray = new ArrayList<Double>(4);
        rectArray.add(0, llx);
        rectArray.add(1, lly);
        rectArray.add(2, urx);
        rectArray.add(3, ury);
        this.setDictionaryArrayValue(ASName.k_BBox, rectArray);
    }

    public double[] getBackground() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Background);
        if (cosArray == null) {
            return null;
        }
        return cosArray.getArrayDouble();
    }

    protected void setBackground(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_Background, value);
    }

    public boolean getAntiAlias() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_AntiAlias);
    }

    protected void setAntiAlias(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryBooleanValue(ASName.k_AntiAlias, value);
    }

    protected void setShadingType(long shadingType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_ShadingType, shadingType);
    }

    public boolean hasShadingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ShadingType);
    }

    public int requireShadingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_ShadingType);
    }

    public int getShadingType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_ShadingType);
    }

    public PDFFunctionsArray getFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Function);
        if (cosObject instanceof CosArray) {
            return PDFFunctionsArray.getInstance(cosObject);
        }
        PDFFunctionsArray pdfFunctionArray = PDFFunctionsArray.newInstance(this.getPDFDocument());
        pdfFunctionArray.add(PDFFunctionFactory.getInstance(cosObject));
        return pdfFunctionArray;
    }

    public boolean hasFunction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Function);
    }

    protected void setFunctionArray(PDFFunction value, boolean requiredType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null && requiredType) {
            throw new PDFInvalidParameterException("FunctionArray is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Function, value);
    }

    protected void setFunctionArray(PDFFunctionsArray children, boolean requiredType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            if (requiredType) {
                throw new PDFInvalidParameterException("FunctionArray is a required key therefore cannot be removed.");
            }
            this.removeValue(ASName.k_Function);
        } else {
            this.setDictionaryArrayValue(ASName.k_Function, children.getCosArray());
        }
    }

    @Override
    public PDFCosDictionary getPDFCosObject() {
        return this;
    }
}

