/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFGroupAttributes
extends PDFCosDictionary {
    private PDFGroupAttributes(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFGroupAttributes getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFGroupAttributes pdfObject = (PDFGroupAttributes)PDFCosObject.getCachedInstance(cosObject, PDFGroupAttributes.class);
        if (pdfObject == null) {
            pdfObject = new PDFGroupAttributes(cosObject);
        }
        return pdfObject;
    }

    public static PDFGroupAttributes newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFGroupAttributes(cosObject);
    }

    public ASName getSubType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setSubType(ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, subType);
    }

    public void setKnockout(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_K, value);
    }

    public boolean getKnockout() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getDictionaryValue(ASName.k_K);
        if (value != null) {
            return value.booleanValue();
        }
        return false;
    }

    public boolean getIsolated() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getDictionaryValue(ASName.k_I);
        if (value != null) {
            return value.booleanValue();
        }
        return false;
    }

    public void setIsolated(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_I, value);
    }

    public void setColorSpace(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_CS, value);
    }

    public ASName getColorSpace() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_CS);
    }
}

