/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;

public class PDFXObjectAltImage
extends PDFCosDictionary {
    private PDFXObjectAltImage(CosObject cosObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObj);
    }

    public static PDFXObjectAltImage getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectAltImage pdfObject = (PDFXObjectAltImage)PDFCosObject.getCachedInstance(cosObject, PDFXObjectAltImage.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectAltImage(cosObject);
        }
        return pdfObject;
    }

    public static PDFXObjectAltImage newInstance(PDFXObjectImage xObjImage, PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectAltImage xObj = PDFXObjectAltImage.getInstance(PDFCosObject.newCosDictionary(pdfDocument));
        xObj.setImage(xObjImage);
        return xObj;
    }

    public PDFXObjectImage getImage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImage result = null;
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Image);
        if (obj != null) {
            result = PDFXObjectImage.getInstance(obj);
        }
        return result;
    }

    public void setImage(PDFXObjectImage image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Image, image);
    }

    public void setAsDefaultForPrinting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_DefaultForPrinting, true);
    }

    public void removeAsDefaultForPrinting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_DefaultForPrinting, false);
    }
}

