/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.xobject;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;

public class PDFXObjectMap
extends PDFCosDictionaryMap<PDFXObject> {
    private PDFXObjectMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFXObjectMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFXObjectMap pdfObject = (PDFXObjectMap)PDFCosObject.getCachedInstance(cosObject, PDFXObjectMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFXObjectMap(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFXObject itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectFactory.getInstance(cosObject);
    }

    public static PDFXObjectMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFXObjectMap pdfObject = new PDFXObjectMap(cosObject);
        return pdfObject;
    }

    public PDFXObject get(ASName name) {
        return (PDFXObject)super.get(name);
    }

    public void set(ASName name, PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, xObject);
    }
}

