/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormImportData;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormReset;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFormSubmit;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;

public abstract class PDFActionForm
extends PDFAction {
    protected PDFActionForm(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFActionForm(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
    }

    public static PDFActionForm getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        if (((CosDictionary)cosObject).containsKey(ASName.k_S)) {
            ASName subtype = ((CosDictionary)cosObject).getName(ASName.k_S);
            if (subtype == ASName.k_SubmitForm) {
                return PDFActionFormSubmit.getInstance(cosObject);
            }
            if (subtype == ASName.k_ResetForm) {
                return PDFActionFormReset.getInstance(cosObject);
            }
            if (subtype == ASName.k_ImportData) {
                return PDFActionFormImportData.getInstance(cosObject);
            }
            if (subtype == ASName.k_JavaScript) {
                return PDFActionJavaScript.getInstance(cosObject);
            }
        }
        return null;
    }
}

