/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;

public class PDFActionMovie
extends PDFAction {
    private PDFActionMovie(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionMovie(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Movie);
    }

    public static PDFActionMovie getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionMovie pdfObject = (PDFActionMovie)PDFCosObject.getCachedInstance(cosObject, PDFActionMovie.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionMovie(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionMovie newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFActionMovie(pdfDocument);
    }

    public PDFAnnotation getAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_Annotation));
    }

    public void setAnnotation(PDFAnnotation pdfAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Annotation, pdfAnnotation);
    }

    public String getTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_T);
    }

    public void setTitle(String title) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_T, title);
    }

    public void setTitle(String title, PDFTextEncoding unicode) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_T, title, unicode);
    }

    public ASName getOperation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Operation);
        if (name == null) {
            return ASName.k_Play;
        }
        return name;
    }

    public void setOperation(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value != ASName.k_Stop && value != ASName.k_Pause && value != ASName.k_Resume && value != ASName.k_Play) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Operation.");
        }
        this.setDictionaryNameValue(ASName.k_Operation, value);
    }
}

