/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;

public class PDFAdditionalActionsPage
extends PDFAdditionalActions {
    private PDFAdditionalActionsPage(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFAdditionalActionsPage(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFAdditionalActionsPage newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAdditionalActionsPage pdfObject = new PDFAdditionalActionsPage(pdfDocument);
        return pdfObject;
    }

    public static PDFAdditionalActionsPage getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAdditionalActionsPage pdfObject = (PDFAdditionalActionsPage)PDFCosObject.getCachedInstance(cosObject, PDFAdditionalActionsPage.class);
        if (pdfObject == null) {
            pdfObject = new PDFAdditionalActionsPage(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFAction itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(cosObject);
    }

    public PDFAction getActionOnOpen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_O));
    }

    public void setActionOnOpen(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_O, action);
    }

    public PDFAction getActionOnClose() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(ASName.k_C));
    }

    public void setActionOnClose(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_C, action);
    }
}

