/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsAnnotation;

public class PDFAdditionalActionsWidget
extends PDFAdditionalActionsAnnotation {
    static final ASName k_Fo = ASName.create("Fo");
    static final ASName k_Bl = ASName.create("Bl");

    private PDFAdditionalActionsWidget(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFAdditionalActionsWidget(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFAdditionalActionsWidget getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAdditionalActionsWidget pdfObject = (PDFAdditionalActionsWidget)PDFCosObject.getCachedInstance(cosObject, PDFAdditionalActionsWidget.class);
        if (pdfObject == null) {
            pdfObject = new PDFAdditionalActionsWidget(cosObject);
        }
        return pdfObject;
    }

    public static PDFAdditionalActionsWidget newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAdditionalActionsWidget pdfObject = new PDFAdditionalActionsWidget(pdfDocument);
        return pdfObject;
    }

    public PDFAction getActionInFocus() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_Fo));
    }

    public void setActionInFocus(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_Fo, action);
    }

    public PDFAction getActionOutFocus() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_Bl));
    }

    public void setActionOutFocus(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_Bl, action);
    }
}

