/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import java.util.ArrayList;

class PDFAnnotationUtils {
    PDFAnnotationUtils() {
    }

    static double[] getInteriorColor(PDFAnnotation pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfAnnot == null) {
            throw new PDFInvalidDocumentException("PDFAnnotation is null");
        }
        CosArray cosColor = pdfAnnot.getDictionaryArrayValue(ASName.k_IC);
        if (cosColor == null) {
            return null;
        }
        return cosColor.getArrayDouble();
    }

    static void setInteriorColor(double[] color, PDFAnnotation pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfAnnot == null) {
            throw new PDFInvalidDocumentException("Annotation is null");
        }
        CosArray cosColor = null;
        if (color != null && color.length != 0) {
            cosColor = PDFCosUtils.newCosArray(pdfAnnot.getPDFDocument());
            for (int i = 0; i < color.length; ++i) {
                cosColor.addDouble(color[i]);
            }
        }
        pdfAnnot.setDictionaryArrayValue(ASName.k_IC, cosColor);
    }

    static void setHighlight(String highlight, PDFAnnotation pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfAnnot == null) {
            throw new PDFInvalidDocumentException("Annotation is null");
        }
        if (highlight != null) {
            if (highlight.equalsIgnoreCase("push")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "P");
            }
            if (highlight.equalsIgnoreCase("outline")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "O");
            }
            if (highlight.equalsIgnoreCase("invert")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "I");
            }
            if (highlight.equalsIgnoreCase("none")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "N");
            }
            if (highlight.equalsIgnoreCase("p")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "P");
            }
            if (highlight.equalsIgnoreCase("o")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "O");
            }
            if (highlight.equalsIgnoreCase("i")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "I");
            }
            if (highlight.equalsIgnoreCase("n")) {
                pdfAnnot.setDictionaryNameValue(ASName.k_H, "N");
            }
        }
    }

    static double[] transformFringe(PDFAnnotation annot, ASMatrix matrix, double rotationAngle, double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        double[] newFringe = null;
        if (fringe != null) {
            PDFDocument doc = annot.getPDFDocument();
            PDFRectangle annotRect = annot.getRect().normalized(doc);
            ASRectangle fringedRect = new ASRectangle(annotRect.left() + fringe[0], annotRect.bottom() + fringe[3], annotRect.right() - fringe[2], annotRect.top() - fringe[1]);
            PDFRectangle transAnnotRect = PDFRectangle.newInstance(doc, annotRect.getRectangle().transform(matrix)).normalized(doc);
            PDFRectangle transFringedRect = PDFRectangle.newInstance(doc, fringedRect.transform(matrix)).normalized(doc);
            newFringe = new double[]{transFringedRect.left() - transAnnotRect.left(), transAnnotRect.top() - transFringedRect.top(), transAnnotRect.right() - transFringedRect.right(), transFringedRect.bottom() - transAnnotRect.bottom()};
        }
        return newFringe;
    }

    static double[] transfromRectangle(double[] rect, double width, double height, int rotationAngle) {
        double[] newRect = new double[rect.length];
        switch (rotationAngle) {
            case 0: {
                return rect;
            }
            case 90: {
                for (int i = 0; i < rect.length; i += 2) {
                    newRect[i] = width - rect[i + 1];
                    newRect[i + 1] = rect[i];
                }
                break;
            }
            case 180: {
                for (int i = 0; i < rect.length; i += 2) {
                    newRect[i] = width - rect[i];
                    newRect[i + 1] = height - rect[i + 1];
                }
                break;
            }
            case 270: {
                for (int i = 0; i < rect.length; i += 2) {
                    newRect[i] = rect[i + 1];
                    newRect[i + 1] = height - rect[i];
                }
                break;
            }
        }
        return newRect;
    }

    static ArrayList<Double> getList(double[] array) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }
}

