/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFBorderEffects
extends PDFCosDictionary {
    private PDFBorderEffects(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFBorderEffects getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBorderEffects pdfObject = (PDFBorderEffects)PDFCosObject.getCachedInstance(cosObject, PDFBorderEffects.class);
        if (pdfObject == null) {
            pdfObject = new PDFBorderEffects(cosObject);
        }
        return pdfObject;
    }

    public static PDFBorderEffects newInstance(PDFDocument pdfDocument, ASName style, double intensity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderEffects pdfObject = PDFBorderEffects.newInstance(pdfDocument);
        pdfObject.setDictionaryNameValue(ASName.k_S, style);
        pdfObject.setDictionaryDoubleValue(ASName.k_I, intensity);
        return pdfObject;
    }

    static PDFBorderEffects newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFBorderEffects(cosObject);
    }

    public double getIntensity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number val = this.getDictionaryNumericValue(ASName.k_I);
        if (val != null) {
            return val.doubleValue();
        }
        return 0.0;
    }

    public String getIntensityAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return Double.toString(this.getIntensity());
    }

    public void setIntensity(String intensity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryDoubleValue(ASName.k_I, intensity);
    }

    public boolean hasIntensity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_I);
    }

    public ASName getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName value = this.getDictionaryNameValue(ASName.k_S);
        return value != null ? value : ASName.k_S;
    }

    public void setStyle(ASName style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, style);
    }

    public boolean hasStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }
}

