/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.fontengine.font.Base14;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsField;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJSCalculateActionEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJSFormatActionEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJSKeystrokeActionEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJSValidateActionEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJavaScriptEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PDFField
extends PDFFieldNode {
    private PDFFieldEmptyAnnotationIterator emptyAnnotationIterator = null;
    public static final ASName ASNAME_DEFAULT_FONT = ASName.create("Helv");
    private static final String DEFAULT_APPEARANCE_DEFAULT_VALUE = "/Helv 0 Tf 0 g";

    protected PDFField(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFField getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null || !(cosObject instanceof CosDictionary)) {
            return null;
        }
        return PDFFieldFactory.getInstance(cosObject, PDFField.getFieldType((CosDictionary)cosObject));
    }

    public void init(PDFFieldNode parent, String fieldName, String defaultFieldBaseName, PDFDefaultAppearance da, boolean useUnicodeEncoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setParentNodeAndDA(parent, da);
        this.setPartialFieldName(parent, fieldName, defaultFieldBaseName, useUnicodeEncoding);
    }

    private void setParentNodeAndDA(PDFFieldNode parent, PDFDefaultAppearance da) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (parent == null) {
            throw new PDFInvalidParameterException("A valid parent field node must be provided.");
        }
        parent.addChild(this);
        this.setDefaultAppearanceForVariableText(da);
    }

    private void setDefaultAppearanceForVariableText(PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFVariableText vt = this.getVariableText();
        if (da != null) {
            try {
                PDFDefaultAppearanceWrapper daImpl = new PDFDefaultAppearanceWrapper(da);
                String fontName = daImpl.getFontName();
                PDFFontMap acroFormFontMap = this.getPDFDocument().requireCatalog().procureInteractiveForm().procureResources().procureFontMap();
                if (!acroFormFontMap.containsKey((Object)ASName.create(fontName)) && Base14.fromPSName(fontName) == null) {
                    PDFFont theFont;
                    boolean openTypeOK = true;
                    if (this.getPDFDocument().procureToSaveVersion().lessThan(PDFVersion.v1_7)) {
                        openTypeOK = false;
                    }
                    if ((theFont = PDFFontUtils.createFontForEditting(this.getPDFDocument(), fontName, false, openTypeOK)) == null) {
                        throw new PDFInvalidDocumentException("Cannot find font.");
                    }
                    acroFormFontMap.set(acroFormFontMap.getNewName(fontName), theFont);
                }
            }
            catch (PDFException e) {
                throw new PDFInvalidParameterException("Invalid DA supplied", e);
            }
            vt.setDefaultAppearance(da);
        } else {
            PDFInteractiveForm currentInteractiveForm = this.getPDFDocument().requireCatalog().procureInteractiveForm();
            if (!PDFCosUtils.containsInheritableKey(ASName.k_DA, ASName.k_Parent, this) && !currentInteractiveForm.dictionaryContains(ASName.k_DA)) {
                vt.setDefaultAppearance(DEFAULT_APPEARANCE_DEFAULT_VALUE);
                PDFFontMap acroFormFontMap = currentInteractiveForm.procureResources().procureFontMap();
                if (!acroFormFontMap.containsKey((Object)ASNAME_DEFAULT_FONT)) {
                    PDFFontSimple defaultFont = PDFFontSimple.newInstance(this.getPDFDocument(), ASName.k_Helvetica, ASName.k_Type1);
                    acroFormFontMap.set(ASNAME_DEFAULT_FONT, defaultFont);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPartialFieldName(PDFFieldNode parent, String fieldName, String defaultFieldBaseName, boolean useUnicodeEncoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fieldName != null && !fieldName.equals("")) {
            if (!PDFFieldUtils.isPartialNameAllowed(fieldName, this)) throw new PDFInvalidParameterException("The name to be applied to the signature terminal field is not allowed.");
            this.setPartialName(fieldName, useUnicodeEncoding);
            return;
        } else {
            this.setPartialName(PDFFieldUtils.generateUniqueFieldName(parent, defaultFieldBaseName), useUnicodeEncoding);
        }
    }

    PDFAnnotationWidget initWidgetAnnot(PDFPage page, PDFRectangle annotRect, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget widget;
        if (combineFieldAnnot) {
            widget = PDFAnnotationWidget.getInstance(this.getCosObject());
            widget.getCosDictionary().put(ASName.k_Type, ASName.k_Annot);
            widget.setSubtype(ASName.k_Widget);
            widget.setRect(annotRect);
            widget.setPage(page);
            PDFAnnotationList annots = page.getAnnotationList();
            if (annots == null) {
                annots = PDFAnnotationList.newInstance(page.getPDFDocument());
                page.setAnnotationList(annots);
            }
            annots.add(widget);
        } else {
            widget = PDFAnnotationWidget.newInstance(page, annotRect);
            this.addAnnotation(widget);
            widget.setParentField(this);
        }
        widget.setPrintable(true);
        return widget;
    }

    @Override
    public boolean isTerminalField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return true;
    }

    @Override
    public boolean isAcrobatAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.isAnnotation() && !this.getCosDictionary().containsKey(ASName.k_T) && !this.getCosDictionary().containsKey(ASName.k_FT);
    }

    @Override
    public PDFFieldList getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public boolean isAnnotation() {
        return this.getCosDictionary().containsKey(ASName.k_Subtype);
    }

    public boolean hasAnnotations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = PDFFieldList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Kids));
        if (kids == null) {
            return this.isAnnotation();
        }
        return true;
    }

    public void setJavaScriptAction(String script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFieldList list = this.getChildren(true);
        if (list != null && !list.isEmpty()) {
            Iterator<PDFFieldNode> i = list.iterator(true);
            while (i.hasNext()) {
                PDFField f = (PDFField)i.next();
                PDFAction act = PDFActionFactory.getInstance(PDFCosUtils.getInheritableValue(ASName.k_A, ASName.k_Parent, f));
                if (act instanceof PDFActionJavaScript) {
                    ((PDFActionJavaScript)act).setJavaScript(f.getPDFDocument(), script);
                    continue;
                }
                PDFActionJavaScript field = PDFActionJavaScript.newInstance(f.getPDFDocument(), PDFText.newInstance(f.getPDFDocument(), script));
                f.setActions(field);
            }
        } else {
            PDFAnnotationIterator iter = this.getAnnotationsIterator();
            while (iter != null && iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                PDFActionJavaScript field = PDFActionJavaScript.newInstance(this.getPDFDocument(), PDFText.newInstance(this.getPDFDocument(), script));
                annot.setAction(field);
            }
        }
    }

    public PDFAnnotationIterator getAnnotationsIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_Kids)) {
            return this.getAnnotations().iterator();
        }
        if (this.isAnnotation()) {
            return new PDFFieldSingleAnnotationIterator(this);
        }
        return this.getEmptyAnnotationIterator();
    }

    public PDFAnnotationList getAnnotations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Kids));
    }

    @Override
    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAdditionalActions aas = PDFAdditionalActions.getInstance(this.getDictionaryDictionaryValue(ASName.k_AA), null);
        if (aas == null && this.isAcrobatAnnotation()) {
            return PDFAdditionalActions.getInstance(this.getParent().getDictionaryDictionaryValue(ASName.k_AA), null);
        }
        if (aas != null && aas.keySet().isEmpty() && this.isAcrobatAnnotation()) {
            return PDFAdditionalActions.getInstance(this.getParent().getDictionaryDictionaryValue(ASName.k_AA), null);
        }
        return PDFAdditionalActions.getInstance(this.getDictionaryDictionaryValue(ASName.k_AA), null);
    }

    public PDFJavaScriptEvent getJavaScriptCalculateEvent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction calcAction;
        PDFAdditionalActionsField aas = (PDFAdditionalActionsField)this.getAdditionalActions();
        if (aas != null && (calcAction = aas.getActionOnCalculate()) != null) {
            return new PDFJSCalculateActionEvent(this, (PDFActionJavaScript)calcAction);
        }
        return null;
    }

    public PDFJavaScriptEvent getJavaScriptValidateEvent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction calcAction;
        PDFAdditionalActionsField aas = (PDFAdditionalActionsField)this.getAdditionalActions();
        if (aas != null && (calcAction = aas.getActionOnChange()) != null) {
            return new PDFJSValidateActionEvent(this, (PDFActionJavaScript)calcAction);
        }
        return null;
    }

    public PDFJavaScriptEvent getJavaScriptFormatEvent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction calcAction;
        PDFAdditionalActionsField aas = (PDFAdditionalActionsField)this.getAdditionalActions();
        if (aas != null && (calcAction = aas.getActionOnFormat()) != null) {
            return new PDFJSFormatActionEvent(this, (PDFActionJavaScript)calcAction);
        }
        return null;
    }

    public PDFJavaScriptEvent getJavaScriptKeystrokeEvent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAction calcAction;
        PDFAdditionalActionsField aas = (PDFAdditionalActionsField)this.getAdditionalActions();
        if (aas != null && (calcAction = aas.getActionOnKeystroke()) != null) {
            return new PDFJSKeystrokeActionEvent(this, (PDFActionJavaScript)calcAction);
        }
        return null;
    }

    public PDFJavaScriptEvent getJavaScriptEvents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<ASName> aasMap;
        Iterator<ASName> i;
        PDFAdditionalActionsField aas = (PDFAdditionalActionsField)this.getAdditionalActions();
        if (aas != null && (i = (aasMap = aas.keySet()).iterator()).hasNext()) {
            ASName actName = i.next();
            return new PDFJavaScriptEvent(this, (PDFActionJavaScript)aas.getAction(actName), actName.toString());
        }
        return null;
    }

    public void setAnnotations(PDFAnnotationList annots) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Kids, annots);
    }

    public void addAnnotation(PDFAnnotation widget) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annots = this.getAnnotations();
        if (annots == null) {
            annots = PDFAnnotationList.newInstance(this.getPDFDocument());
            this.setAnnotations(annots);
        }
        annots.add(widget);
        PDFField widgetField = PDFField.getInstance(widget.getCosObject());
        if (widgetField != null) {
            PDFFieldNode parentField = widgetField.getParent();
            if (parentField != null) {
                parentField.removeChild(widgetField);
            }
            widgetField.setParent(this);
        }
    }

    private PDFAnnotationIterator getEmptyAnnotationIterator() {
        if (this.emptyAnnotationIterator == null) {
            this.emptyAnnotationIterator = new PDFFieldEmptyAnnotationIterator();
        }
        return this.emptyAnnotationIterator;
    }

    private static ASName getFieldType(CosDictionary cosDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject fieldType = cosDict.getInheritable(ASName.k_FT, ASName.k_Parent);
        if (fieldType instanceof CosName) {
            return ((CosName)fieldType).nameValue();
        }
        return null;
    }

    static class PDFFieldEmptyAnnotationIterator
    implements PDFAnnotationIterator {
        PDFFieldEmptyAnnotationIterator() {
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public PDFAnnotation next() {
            return null;
        }
    }

    class PDFFieldSingleAnnotationIterator
    implements PDFAnnotationIterator {
        private final PDFField field;
        private final PDFAnnotation annotation;
        private boolean hasNext = true;

        PDFFieldSingleAnnotationIterator(PDFField pdfField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.annotation = PDFAnnotationFactory.getInstance(pdfField.getCosObject());
            this.field = pdfField;
        }

        @Override
        public void remove() {
            try {
                CosDictionary orgCosField = this.field.getCosDictionary();
                CosDictionary newCosField = PDFField.newCosDictionary(PDFField.this.getPDFDocument());
                PDFFieldNode parent = PDFField.this.getParent();
                if (parent == null) {
                    parent = PDFField.this.getPDFDocument().getInteractiveForm();
                }
                PDFFieldList list = parent.getChildren();
                for (int i = 0; i < list.size(); ++i) {
                    PDFFieldNode curField = (PDFFieldNode)list.get(i);
                    if (curField != this.field) continue;
                    this.field.replaceCosObject(newCosField);
                    list.set(i, this.field);
                    break;
                }
                Iterator<ASName> fieldIterator = orgCosField.keyIterator();
                while (fieldIterator.hasNext()) {
                    ASName key = fieldIterator.next();
                    if (!Utility.nameInArray(key, PDFFieldNode.pureFieldAndStructureKeys)) continue;
                    newCosField.put(key, orgCosField.get(key));
                    fieldIterator.remove();
                }
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error in PDFFieldAnnotationIterator remove().");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public PDFAnnotation next() {
            this.hasNext = false;
            return this.annotation;
        }
    }

    static class PDFFieldFilter {
        private final ASName fieldType;

        PDFFieldFilter(PDFFieldType fieldType) {
            this.fieldType = fieldType.getValue();
        }

        public boolean accept(CosObject object) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (!(object instanceof CosDictionary)) {
                return false;
            }
            return PDFField.getFieldType((CosDictionary)object) == this.fieldType;
        }
    }
}

