/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFNamedPages
extends PDFNameTree<PDFPage> {
    private PDFNamedPages(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNamedPages newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFNamedPages(cosObject);
    }

    public static PDFNamedPages getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNamedPages pdfObject = (PDFNamedPages)PDFCosObject.getCachedInstance(cosObject, PDFNamedPages.class);
        if (pdfObject == null) {
            pdfObject = new PDFNamedPages(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFPage makeValueType(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFPage.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFPage value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

