/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;

public class PDFBookmarkRoot
extends PDFBookmarkNode {
    private PDFBookmarkRoot(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFBookmarkRoot getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFBookmarkRoot pdfObject = (PDFBookmarkRoot)PDFCosObject.getCachedInstance(cosObject, PDFBookmarkRoot.class);
        if (pdfObject == null) {
            pdfObject = new PDFBookmarkRoot(cosObject);
        }
        return pdfObject;
    }

    public static PDFBookmarkRoot newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = PDFCosObject.newCosDictionary(pdfDocument);
        cosDict.put(ASName.k_Type, ASName.k_Outlines);
        PDFBookmarkRoot root = new PDFBookmarkRoot(cosDict);
        root.setCount(0);
        return root;
    }

    public static PDFBookmarkRoot newInstance(PDFDocument pdfDocument, PDFBookmark bookmark) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmarkRoot root = PDFBookmarkRoot.newSkeletonInstance(pdfDocument);
        if (bookmark != null) {
            PDFBookmarkUtils.appendLastKid(bookmark, root);
        }
        return root;
    }

    @Override
    public PDFBookmark findDepthFirst(String title) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark b = this.getFirstKid();
        if (b != null) {
            return b.findDepthFirst(title);
        }
        return null;
    }

    @Override
    public int getCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer count = this.getDictionaryIntValue(ASName.k_Count);
        if (count != null) {
            return count > 0 ? count : 0;
        }
        return 0;
    }
}

