/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;

public class PDFNamedDestinations
extends PDFNameTree<PDFDestination> {
    private PDFNamedDestinations(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNamedDestinations getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNamedDestinations pdfObject = (PDFNamedDestinations)PDFCosObject.getCachedInstance(cosObject, PDFNamedDestinations.class);
        if (pdfObject == null) {
            pdfObject = new PDFNamedDestinations(cosObject);
        }
        return pdfObject;
    }

    public static PDFNamedDestinations newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFNamedDestinations(cosObject);
    }

    @Override
    protected PDFDestination makeValueType(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFDestination.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFDestination value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

