/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.HashMap;

public enum PDFTransitionStyle {
    Split(ASName.create("Split")),
    Blinds(ASName.create("Blinds")),
    Box(ASName.create("Box")),
    Wipe(ASName.create("Wipe")),
    Dissolve(ASName.create("Dissolve")),
    Glitter(ASName.create("Glitter")),
    R(ASName.create("R")),
    Fly(ASName.create("Fly")),
    Push(ASName.create("Push")),
    Cover(ASName.create("Cover")),
    Uncover(ASName.create("Uncover")),
    Fade(ASName.create("Fade"));

    private static HashMap<ASName, PDFTransitionStyle> nameToStyleMap;
    private ASName transitionStyleName;

    private PDFTransitionStyle(ASName transitionStyleName) {
        this.transitionStyleName = transitionStyleName;
    }

    public ASName getTransitionStyleName() {
        return this.transitionStyleName;
    }

    public static PDFTransitionStyle getInstance(ASName transitionStyleName) {
        return nameToStyleMap.get(transitionStyleName);
    }

    static {
        nameToStyleMap = new HashMap();
        PDFTransitionStyle.values();
        for (PDFTransitionStyle transitionStyle : PDFTransitionStyle.values()) {
            nameToStyleMap.put(transitionStyle.getTransitionStyleName(), transitionStyle);
        }
    }
}

