/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionNavigatorStringsTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionResourcesTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSWFLoadType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import java.util.Locale;

public class PDFCollectionNavigator
extends PDFCosDictionary {
    public static final ASName k_SWF = ASName.create("SWF");
    public static final ASName k_Name = ASName.create("Name");
    public static final ASName k_Desc = ASName.create("Desc");
    public static final ASName k_Category = ASName.create("Category");
    public static final ASName k_APIVersion = ASName.create("APIVersion");
    public static final ASName k_Icon = ASName.create("Icon");
    public static final ASName k_Locale = ASName.create("Locale");
    public static final ASName k_LoadType = ASName.create("LoadType");
    public static final ASName k_Strings = ASName.create("Strings");
    public static final ASName k_InitialFields = ASName.create("InitialFields");
    public static final ASName k_Resources = ASName.create("Resources");

    private PDFCollectionNavigator(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionNavigator getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionNavigator pdfObject = (PDFCollectionNavigator)PDFCosObject.getCachedInstance(cosObject, PDFCollectionNavigator.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionNavigator(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionNavigator newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionNavigator pdfObject = new PDFCollectionNavigator(cosObject);
        return pdfObject;
    }

    public String getSWF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_SWF);
    }

    public void setSWF(String swf) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_SWF, swf);
    }

    public void setSWF(String swf, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_SWF, swf, unicode);
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Name);
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Name, name);
    }

    public void setName(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Name, name, unicode);
    }

    public String getDesc() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Desc);
    }

    public void setDesc(String desc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (desc == null) {
            this.removeValue(k_Desc);
        } else {
            this.setDictionaryStringValue(k_Desc, desc);
        }
    }

    public void setDesc(String desc, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (desc == null) {
            this.removeValue(k_Desc);
        } else {
            this.setDictionaryStringValue(k_Desc, desc, unicode);
        }
    }

    public String getCategory() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Category);
    }

    public void setCategory(String category) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (category == null) {
            this.removeValue(k_Category);
        } else {
            this.setDictionaryStringValue(k_Category, category);
        }
    }

    public void setCategory(String category, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (category == null) {
            this.removeValue(k_Category);
        } else {
            this.setDictionaryStringValue(k_Category, category, unicode);
        }
    }

    public String getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_ID);
    }

    public void setID(String id) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ID, id);
    }

    public void setID(String id, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ID, id, unicode);
    }

    public String getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Version);
    }

    public void setVersion(String version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (version == null) {
            this.removeValue(ASName.k_Version);
        } else {
            this.setDictionaryStringValue(ASName.k_Version, version);
        }
    }

    public void setVersion(String version, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (version == null) {
            this.removeValue(ASName.k_Version);
        } else {
            this.setDictionaryStringValue(ASName.k_Version, version, unicode);
        }
    }

    public String getAPIVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_APIVersion);
    }

    public void setAPIVersion(String apiVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (apiVersion == null) {
            this.removeValue(k_APIVersion);
        } else {
            this.setDictionaryStringValue(k_APIVersion, apiVersion);
        }
    }

    public void setAPIVersion(String apiVersion, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (apiVersion == null) {
            this.removeValue(k_APIVersion);
        } else {
            this.setDictionaryStringValue(k_APIVersion, apiVersion, unicode);
        }
    }

    public String getIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Icon);
    }

    public void setIcon(String icon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (icon == null) {
            this.removeValue(k_Icon);
        } else {
            this.setDictionaryStringValue(k_Icon, icon);
        }
    }

    public void setIcon(String icon, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (icon == null) {
            this.removeValue(k_Icon);
        } else {
            this.setDictionaryStringValue(k_Icon, icon, unicode);
        }
    }

    public boolean hasLocale() {
        return this.getCosDictionary().containsKey(k_Locale);
    }

    public Locale getLocale() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String localeString = this.getDictionaryTextStringValue(k_Locale);
        return PDFCollectionNavigator.getLocaleFromString(localeString);
    }

    public static Locale getLocaleFromString(String locale) {
        if (locale == null) {
            return null;
        }
        String[] parts = locale.split("_");
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return new Locale(locale);
    }

    public void setLocale(Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (locale == null) {
            this.removeValue(k_Locale);
        } else {
            this.setDictionaryStringValue(k_Locale, locale.toString());
        }
    }

    public PDFCollectionSWFLoadType getLoadType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName loadType = this.getDictionaryNameValue(k_LoadType);
        if (loadType == null) {
            return PDFCollectionSWFLoadType.defaultSWF;
        }
        return PDFCollectionSWFLoadType.getInstance(loadType);
    }

    public void setLoadType(PDFCollectionSWFLoadType loadType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (loadType == null) {
            this.removeValue(k_LoadType);
        } else {
            this.setDictionaryNameValue(k_LoadType, loadType.getLoadType());
        }
    }

    public PDFCollectionNavigatorStringsTree getStrings() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionNavigatorStringsTree.getInstance(this.getDictionaryValue(k_Strings));
    }

    public void setStrings(PDFCollectionNavigatorStringsTree strings) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (strings == null) {
            this.removeValue(k_Strings);
        } else {
            this.setDictionaryValue(k_Strings, strings);
        }
    }

    public PDFCollectionSchema getInitialFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionSchema.getInstance(this.getDictionaryValue(k_InitialFields));
    }

    public void setInitialFields(PDFCollectionSchema initialFields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (initialFields == null) {
            this.removeValue(k_InitialFields);
        } else {
            this.setDictionaryValue(k_InitialFields, initialFields);
        }
    }

    public PDFCollectionResourcesTree getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionResourcesTree.getInstance(this.getDictionaryValue(k_Resources));
    }

    public void setResources(PDFCollectionResourcesTree resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (resources == null) {
            this.removeValue(k_Resources);
        } else {
            this.setDictionaryValue(k_Resources, resources);
        }
    }
}

