/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSortItem;

public class PDFCollectionSortIterator {
    private CosArray mNamesArray = null;
    private ASName mNextName = null;
    private int mNamesSize = 0;
    private int mNamesInd = 0;
    private CosArray mOrderArray = null;
    private Boolean mNextOrder = null;
    private int mOrdersSize = 0;
    private static final boolean defaultOrder = true;

    PDFCollectionSortIterator(CosObject names, CosObject order) {
        if (names != null) {
            if (names.getType() == 5) {
                this.mNamesArray = (CosArray)names;
                this.mNamesSize = ((CosArray)names).size();
            } else {
                this.mNextName = names.nameValue();
                this.mNamesSize = 1;
            }
        }
        if (order != null) {
            if (order.getType() == 5) {
                this.mOrderArray = (CosArray)order;
                this.mOrdersSize = ((CosArray)order).size();
            } else {
                this.mNextOrder = order.booleanValue();
                this.mOrdersSize = 1;
            }
        }
    }

    public void remove() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mNamesInd < this.mNamesSize && this.mOrderArray != null) {
            this.mOrderArray.remove(this.mNamesInd);
        }
        if (this.mNamesArray != null) {
            this.mNamesArray.remove(this.mNamesInd--);
        }
    }

    public boolean hasNext() {
        return this.mNamesInd < this.mNamesSize;
    }

    public PDFCollectionSortItem nextItem() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName nextName = this.mNamesArray != null ? this.mNamesArray.get(this.mNamesInd).nameValue() : this.mNextName;
        this.mNextName = null;
        boolean nextOrder = true;
        if (this.mNamesInd < this.mOrdersSize) {
            nextOrder = this.mOrderArray != null ? this.mOrderArray.get(this.mNamesInd).booleanValue() : this.mNextOrder.booleanValue();
        }
        this.mNextOrder = null;
        ++this.mNamesInd;
        return new PDFCollectionSortItem(nextName, nextOrder);
    }

    public int size() {
        return this.mNamesSize;
    }
}

