/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.readerrequirements;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.Arrays;

public class PDFReaderRequirement
extends PDFCosDictionary {
    private static final ASName[] definedReaderRequirementsList = new ASName[]{ASName.k_UseOutputIntent, ASName.k_NoICCAlternates, ASName.k_StrictSeparationColors, ASName.k_IgnoreDeviceGS, ASName.k_RequireOverprintPreview, ASName.k_StrictJP2KColor, ASName.k_StrictAppearances, ASName.k_DisplayAnnotationContents, ASName.k_DisableNonGoToActions, ASName.k_DisplayActionInfo, ASName.k_IgnoreDocInfo, ASName.k_IgnoreThumbs, ASName.k_IgnoreTransitions, ASName.k_StrictOptionalContent, ASName.k_DisplayEmbeddedFiles};
    private static final ASName[] definedOutputIntentChoiceList = new ASName[]{ASName.k_GTS_PDFX, ASName.k_GTS_PDFA1, ASName.k_ISO_PDFE1};

    private PDFReaderRequirement(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFReaderRequirement newInstance(PDFDocument pdfDocument, ASName key_ReaderRequirementType, ASName key_OutputIntentChoice) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_ReaderRequirementType == null) {
            throw new PDFInvalidParameterException("ReaderRequirementType is required when creating newInstance of PDFReaderRequirements.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFReaderRequirement pdfObject = new PDFReaderRequirement(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_ReaderRequirement);
        pdfObject.setReaderRequirementType(key_ReaderRequirementType);
        if (key_ReaderRequirementType == ASName.k_UseOutputIntent) {
            pdfObject.setOutputIntentChoice(key_OutputIntentChoice);
        }
        return pdfObject;
    }

    public static PDFReaderRequirement getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFReaderRequirement pdfObject = (PDFReaderRequirement)PDFCosObject.getCachedInstance(cosObject, PDFReaderRequirement.class);
        if (pdfObject == null) {
            pdfObject = new PDFReaderRequirement(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public ASName getReaderRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public ASName requireReaderRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get RequirementType.");
        }
        return name;
    }

    public void setReaderRequirementType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("RequirementType is a required key therefore cannot be removed.");
        }
        if (!Arrays.asList(definedReaderRequirementsList).contains(value)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for ReaderRequirementType.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName getOutputIntentChoice() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_OutputIntentChoice);
    }

    public void setOutputIntentChoice(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("OutputIntentChoice is a required key therefore cannot be removed.");
        }
        if (!Arrays.asList(definedOutputIntentChoiceList).contains(value)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for OutputIntentChoice.");
        }
        this.setDictionaryNameValue(ASName.k_OutputIntentChoice, value);
    }
}

