/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.requirement;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.requirement.PDFRHArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PDFRequirement
extends PDFCosDictionary {
    private List<ASName> requirementsTypes = new ArrayList<ASName>(Arrays.asList(ASName.k_OCInteract, ASName.k_OCAutoStates, ASName.k_AcroFormInteract, ASName.k_XFARender, ASName.k_XFAInteract, ASName.k_Navigation, ASName.k_Markup, ASName.k_3DMarkup, ASName.k_Multimedia, ASName.k_U3D, ASName.k_PRC, ASName.k_Action, ASName.k_EnableJavaScripts, ASName.k_Attachment, ASName.k_AttachmentEditing, ASName.k_Collection, ASName.k_CollectionEditing, ASName.k_DigSigValidation, ASName.k_DigSig, ASName.k_DigSigMDP, ASName.k_Barcode, ASName.k_RichMedia, ASName.k_Geospatial2D, ASName.k_Geospatial3D, ASName.k_DPartInteract, ASName.k_DPartInteract, ASName.k_SeparationSimulation, ASName.k_StrictAnnotations, ASName.k_StrictActions, ASName.k_Transitions, ASName.k_Encryption));

    private PDFRequirement(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRequirement newInstance(PDFDocument pdfDocument, ASName key_RequirementType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_RequirementType == null) {
            throw new PDFInvalidParameterException("RequirementType is required when creating newInstance of PDFRequirements.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRequirement pdfObject = new PDFRequirement(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_Requirement);
        pdfObject.setRequirementType(key_RequirementType);
        return pdfObject;
    }

    public static PDFRequirement getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRequirement pdfObject = (PDFRequirement)PDFCosObject.getCachedInstance(cosObject, PDFRequirement.class);
        if (pdfObject == null) {
            pdfObject = new PDFRequirement(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setRequirementType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("RequirementType is a required key therefore cannot be removed.");
        }
        if (!this.requirementsTypes.contains(value)) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for RequirementType.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get RequirementType.");
        }
        return name;
    }

    public boolean hasRequirementType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFRHArray getRH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject requirementHandler = this.getDictionaryValue(ASName.k_RH);
        if (requirementHandler instanceof CosArray) {
            return PDFRHArray.getInstance(requirementHandler);
        }
        return null;
    }

    public void setRH(PDFRHArray pdfRHArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_RH, pdfRHArray);
    }

    public boolean hasRH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RH);
    }

    public void setVersion(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_V, name);
    }

    public ASName getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_V);
    }

    public Integer getPenalty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer penalty = this.getDictionaryIntValue(ASName.k_Penalty);
        if (penalty != null) {
            return penalty;
        }
        return 0;
    }

    public void setPenalty(Integer penalty) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Penalty, penalty.intValue());
    }
}

