/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFAliasedURL
extends PDFCosDictionary {
    private PDFAliasedURL(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFAliasedURL newInstance(PDFDocument pdfDocument, ASString key_DestinationURL) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_DestinationURL == null) {
            throw new PDFInvalidParameterException("DestinationURL is required when creating newInstance of PDFAliasedURL.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFAliasedURL pdfObject = new PDFAliasedURL(cosObject);
        pdfObject.setDestinationURL(key_DestinationURL);
        return pdfObject;
    }

    public static PDFAliasedURL getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAliasedURL pdfObject = (PDFAliasedURL)PDFCosObject.getCachedInstance(cosObject, PDFAliasedURL.class);
        if (pdfObject == null) {
            pdfObject = new PDFAliasedURL(cosObject);
        }
        return pdfObject;
    }

    public ASString getDestinationURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_U);
    }

    public void setDestinationURL(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("DestinationURL is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_U, value);
    }

    public void setDestinationURL(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("DestinationURL is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_U, value);
    }

    public ASString requireDestinationURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_U);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get DestinationURL");
        }
        return name;
    }

    public boolean hasDestinationURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_U);
    }

    public CosArray getChain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_C);
    }

    public void setChain(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_C, value);
    }

    public boolean hasChain() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }
}

