/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFApplicationData
extends PDFCosDictionary {
    private PDFApplicationData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFApplicationData getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFApplicationData pdfObject = (PDFApplicationData)PDFCosObject.getCachedInstance(cosObject, PDFApplicationData.class);
        if (pdfObject == null) {
            pdfObject = new PDFApplicationData(cosObject);
        }
        return pdfObject;
    }

    public static PDFApplicationData newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFApplicationData(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public ASDate getLastModified() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_LastModified);
    }

    public void setLastModified(ASDate lastModified) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (lastModified == null) {
            this.removeValue(ASName.k_LastModified);
        } else {
            this.setDictionaryStringValue(ASName.k_LastModified, lastModified.asString());
        }
    }

    public CosObject getPrivateData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryValue(ASName.k_Private);
    }

    public void setPrivateData(PDFCosObject data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (data == null) {
            this.removeValue(ASName.k_Private);
        } else {
            this.setDictionaryValue(ASName.k_Private, data);
        }
    }
}

