/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;

public class PDFDestOutputProfileRef
extends PDFCosDictionary {
    public PDFDestOutputProfileRef(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFDestOutputProfileRef getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDestOutputProfileRef pdfObject = (PDFDestOutputProfileRef)PDFCosObject.getCachedInstance(cosObject, PDFDestOutputProfileRef.class);
        if (pdfObject == null) {
            pdfObject = new PDFDestOutputProfileRef(cosObject);
        }
        return pdfObject;
    }

    public static PDFDestOutputProfileRef newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFDestOutputProfileRef pdfObject = new PDFDestOutputProfileRef(cosObject);
        return pdfObject;
    }

    public void setCheckSum(String checkSum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_CheckSum, checkSum);
    }

    public void setCheckSum(String checkSum, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_CheckSum, checkSum, unicode);
    }

    public String getCheckSum() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(ASName.k_CheckSum);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setICCVersion(String iCCVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ICCVersion, iCCVersion);
    }

    public void setICCVersion(String iCCVersion, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ICCVersion, iCCVersion, unicode);
    }

    public String getICCVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(ASName.k_ICCVersion);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setProfileCS(String profileCS) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ProfileCS, profileCS);
    }

    public void setProfileCS(String profileCS, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ProfileCS, profileCS, unicode);
    }

    public String getProfileCS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(ASName.k_ProfileCS);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setProfileName(String profileName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ProfileName, profileName);
    }

    public void setProfileName(String profileName, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_ProfileName, profileName, unicode);
    }

    public String getProfileName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(ASName.k_ProfileName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public ASName[] getColorantTable() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray entries = this.getDictionaryArrayValue(ASName.k_ColorantTable);
        if (entries != null) {
            return entries.getArrayName();
        }
        return null;
    }

    public void setColorantTable(ASName[] colorantTable) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_ColorantTable, 0, colorantTable);
    }

    public ASName[] getURLs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray urls = this.getDictionaryArrayValue(ASName.k_ColorantTable);
        if (urls != null) {
            return urls.getArrayName();
        }
        return null;
    }

    public void setURLs(ASName[] urls) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_ColorantTable, 0, urls);
    }
}

