/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFOPIColorArray
extends PDFCosObject {
    private PDFOPIColorArray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOPIColorArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFOPIColorArray pdfObject = new PDFOPIColorArray(cosObject);
        return pdfObject;
    }

    public static PDFOPIColorArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOPIColorArray pdfObject = (PDFOPIColorArray)PDFCosObject.getCachedInstance(cosObject, PDFOPIColorArray.class);
        if (pdfObject == null) {
            pdfObject = new PDFOPIColorArray(cosObject);
        }
        return pdfObject;
    }

    public double getElem0() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0.0;
        }
        CosObject cosObject = this.getCosArray().get(0);
        if (!(cosObject instanceof CosNumeric)) {
            return 0.0;
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public void setElem0(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(0, cosObject);
    }

    public boolean hasElem0() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(0);
        return cosObject != null;
    }

    public double getElem1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0.0;
        }
        CosObject cosObject = this.getCosArray().get(1);
        if (!(cosObject instanceof CosNumeric)) {
            return 0.0;
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public void setElem1(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(1, cosObject);
    }

    public boolean hasElem1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(1);
        return cosObject != null;
    }

    public double getElem2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0.0;
        }
        CosObject cosObject = this.getCosArray().get(2);
        if (!(cosObject instanceof CosNumeric)) {
            return 0.0;
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public void setElem2(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(2, cosObject);
    }

    public boolean hasElem2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(2);
        return cosObject != null;
    }

    public double getElem3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return 0.0;
        }
        CosObject cosObject = this.getCosArray().get(3);
        if (!(cosObject instanceof CosNumeric)) {
            return 0.0;
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public void setElem3(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosObject = this.getCosObject().getDocument().createCosNumeric(value);
        this.getCosArray().extendIfNecessaryAndSet(3, cosObject);
    }

    public boolean hasElem3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(3);
        return cosObject != null;
    }

    public ASString getElem4() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return null;
        }
        CosObject cosObject = this.getCosArray().get(4);
        if (!(cosObject instanceof CosString)) {
            return null;
        }
        return new ASString(((CosString)cosObject).byteArrayValue());
    }

    public void setElem4(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar cosObject = value == null ? this.getCosObject().getDocument().createCosNull() : this.getCosObject().getDocument().createCosString(value);
        this.getCosArray().extendIfNecessaryAndSet(4, cosObject);
    }

    public void setElem4(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosScalar cosObject = value == null ? this.getCosObject().getDocument().createCosNull() : this.getCosObject().getDocument().createCosString(value);
        this.getCosArray().extendIfNecessaryAndSet(4, cosObject);
    }

    public boolean hasElem4() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray() == null) {
            return false;
        }
        CosObject cosObject = this.getCosArray().get(4);
        return cosObject != null;
    }
}

