/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.prepress;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFDestOutputProfileRef;

public class PDFOutputIntent
extends PDFCosDictionary {
    protected static final ASName k_OutputIntent = ASName.create("OutputIntent");
    protected static final ASName k_OutputCondition = ASName.create("OutputCondition");
    protected static final ASName k_OutputConditionIdentifier = ASName.create("OutputConditionIdentifier");
    protected static final ASName k_RegistryName = ASName.create("RegistryName");
    protected static final ASName k_Info = ASName.create("Info");
    protected static final ASName k_DestOutputProfile = ASName.create("DestOutputProfile");

    public PDFOutputIntent(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFOutputIntent getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOutputIntent pdfObject = (PDFOutputIntent)PDFCosObject.getCachedInstance(cosObject, PDFOutputIntent.class);
        if (pdfObject == null) {
            pdfObject = new PDFOutputIntent(cosObject);
        }
        return pdfObject;
    }

    public static PDFOutputIntent newInstance(PDFDocument pdfDocument, String subType, String outputConditionIdentifier) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFOutputIntent pdfObject = new PDFOutputIntent(cosObject);
        pdfObject.setOutputConditionIdentifier(outputConditionIdentifier);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_OutputIntent);
        pdfObject.setDictionaryNameValue(ASName.k_S, ASName.create(subType));
        return pdfObject;
    }

    public ASName getSubType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setOutputCondition(String outputCondition) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_OutputCondition, outputCondition);
    }

    public void setOutputCondition(String outputCondition, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_OutputCondition, outputCondition, unicode);
    }

    public String getOutputCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(k_OutputCondition);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setOutputConditionIdentifier(String outputConditionIdentifier) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_OutputConditionIdentifier, outputConditionIdentifier);
    }

    public void setOutputConditionIdentifier(String outputConditionIdentifier, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_OutputConditionIdentifier, outputConditionIdentifier, unicode);
    }

    public String getOutputConditionIdentifier() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(k_OutputConditionIdentifier);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setRegistryName(String registryName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_RegistryName, registryName);
    }

    public void setRegistryName(String registryName, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_RegistryName, registryName, unicode);
    }

    public String getRegistryName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(k_RegistryName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setInfo(String info) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Info, info);
    }

    public void setInfo(String info, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Info, info, unicode);
    }

    public String getInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString value = this.getDictionaryStringValue(k_Info);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public void setDestOutputProfile(PDFICCProfile destOutputProfile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_DestOutputProfile, destOutputProfile);
    }

    public PDFICCProfile getDestOutputProfile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value = this.getDictionaryValue(k_DestOutputProfile);
        if (value == null) {
            return null;
        }
        return PDFICCProfile.getInstance(value);
    }

    public PDFDestOutputProfileRef getDestOutputProfileRef() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDestOutputProfileRef.getInstance(this.getDictionaryDictionaryValue(ASName.k_DestOutputProfileRef));
    }

    public void setDestOutputProfileRef(PDFDestOutputProfileRef pdfDestOutputProfileRef) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_DestOutputProfileRef, pdfDestOutputProfileRef);
    }
}

