/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;

public class PDFStructureIDTree
extends PDFNameTree<PDFStructureElement> {
    private PDFStructureIDTree(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFStructureIDTree getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureIDTree pdfObject = (PDFStructureIDTree)PDFCosObject.getCachedInstance(cosObject, PDFStructureIDTree.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureIDTree(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureIDTree newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFStructureIDTree(cosObject);
    }

    @Override
    protected PDFStructureElement makeValueType(CosObject cosObject) throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFStructureElement.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFStructureElement value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

