/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;

public class PDFStructureMCIDReferences
extends PDFCosArrayList<PDFStructureElement> {
    private PDFStructureMCIDReferences(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFStructureMCIDReferences getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureMCIDReferences pdfObject = (PDFStructureMCIDReferences)PDFCosObject.getCachedInstance(cosObject, PDFStructureMCIDReferences.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureMCIDReferences(cosObject);
        }
        return pdfObject;
    }

    public static PDFStructureMCIDReferences newInstance(PDFDocument pdfDoc, PDFStructureMCID mcid, PDFStructureElement parent) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFStructureMCIDReferences refs = new PDFStructureMCIDReferences(pdfDoc.getCosDocument().createCosArray());
        refs.add(mcid, parent);
        return refs;
    }

    public void add(PDFStructureMCID mcid, PDFStructureElement element) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int pos = mcid.getMCID();
        int size = this.size();
        CosNull nullObj = this.getPDFDocument().getCosDocument().createCosNull();
        for (int ind = size; ind < pos; ++ind) {
            this.getCosArray().add(ind, nullObj);
        }
        this.getCosArray().add(pos, element.getCosObject());
    }

    public PDFStructureElement get(PDFStructureMCID mcid) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        int pos = mcid.getMCID();
        if (pos >= this.size()) {
            return null;
        }
        return this.itemInstantiator(this.getCosArray().get(pos));
    }

    @Override
    protected PDFStructureElement itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFStructureElement.getInstance(cosObject);
    }
}

