/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentScalar;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureType;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class PDFStructureMCR
extends PDFStructureContentScalar {
    private PDFStructureMCR(CosObject item) throws PDFInvalidDocumentException {
        super(item);
    }

    public static PDFStructureMCR getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFStructureMCR pdfObject = (PDFStructureMCR)PDFCosObject.getCachedInstance(cosObject, PDFStructureMCR.class);
        if (pdfObject == null) {
            pdfObject = new PDFStructureMCR(cosObject);
        }
        return pdfObject;
    }

    @Override
    public PDFPage getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPage.getInstance(((CosDictionary)this.contentItem).getCosDictionary(ASName.k_Pg));
    }

    @Override
    public Integer getMCID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number mcid = this.getDictionaryNumericValue(ASName.k_MCID);
        return mcid == null ? null : Integer.valueOf(mcid.intValue());
    }

    public PDFContents getContentStream() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosStream stream = this.getCosDictionary().getCosStream(ASName.k_Stm);
        return PDFContents.getInstance(stream);
    }

    @Override
    public PDFStructureType getStructureType() {
        return PDFStructureType.MCR;
    }
}

