/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFTableAttributes
extends PDFCosDictionary {
    private static final ASName k_Summary = ASName.create("Summary");

    PDFTableAttributes(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFTableAttributes newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFTableAttributes(cosObject);
    }

    public static PDFTableAttributes getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTableAttributes pdfObject = (PDFTableAttributes)PDFCosObject.getCachedInstance(cosObject, PDFTableAttributes.class);
        if (pdfObject == null) {
            pdfObject = new PDFTableAttributes(cosObject);
        }
        return pdfObject;
    }

    public int getColSpan() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_ColSpan);
    }

    public void setColSpan(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_ColSpan, value);
    }

    public boolean hasColSpan() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ColSpan);
    }

    public int getRowSpan() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_RowSpan);
    }

    public void setRowSpan(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_RowSpan, value);
    }

    public boolean hasRowSpan() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RowSpan);
    }

    public ASName getScope() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Scope);
    }

    public void setScope(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Scope);
        } else if (value.equals(ASName.create("Row")) || value.equals(ASName.create("Column")) || value.equals(ASName.create("Both"))) {
            this.setDictionaryNameValue(ASName.k_Scope, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Scope.");
        }
    }

    public boolean hasScope() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Scope);
    }

    public CosArray getHeaders() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Headers);
    }

    public void setHeaders(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Headers, value);
    }

    public boolean hasHeaders() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Headers);
    }

    public ASString getSummary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(k_Summary);
    }

    public void setSummary(ASString summary) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (summary == null) {
            this.removeValue(k_Summary);
        } else {
            this.setDictionaryASStringValue(k_Summary, summary);
        }
    }
}

