/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.ArrayList;
import java.util.List;

public class PDF3DCrossSection
extends PDFCosDictionary {
    private PDF3DCrossSection(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DCrossSection newInstance(PDFDocument pdfDocument, Object[] cosObject2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (cosObject2 == null) {
            throw new PDFInvalidParameterException("Orientatoin is required when creating newInstance of PDF3DCrossSection.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DCrossSection pdfObject = new PDF3DCrossSection(cosObject);
        pdfObject.setOrientation(cosObject2);
        return pdfObject;
    }

    public static PDF3DCrossSection getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DCrossSection pdfObject = (PDF3DCrossSection)PDFCosObject.getCachedInstance(cosObject, PDF3DCrossSection.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DCrossSection(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_3DCrossSection)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public double[] getInteresectionColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_IC);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble(1, 3);
    }

    public void setInteresectionColor(double[] intercolor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (intercolor == null) {
            this.removeValue(ASName.k_IC);
        } else {
            CosArray array = this.setDictionaryArrayValue(ASName.k_IC, 1, intercolor);
            array.setName(0, ASName.k_DeviceRGB);
        }
    }

    public boolean hasInteresectionColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_IC);
    }

    public boolean getIntersectionVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_IV);
    }

    public void setIntersectionVisibility(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_IV, value);
    }

    public boolean hasIntersectionVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_IV);
    }

    public boolean getShowTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_ST);
    }

    public void setgetShowTransparent(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_ST, value);
    }

    public boolean hasShowTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ST);
    }

    public boolean getPlaneVisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_PV);
    }

    public void setPlaneVisible(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_PV, value);
    }

    public boolean hasPlaneVisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PV);
    }

    public double getPlaneOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_PO);
    }

    public void setPlaneOpacity(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_PO, value);
    }

    public boolean hasPlaneOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PO);
    }

    public double[] getPlaneColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_PC);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble(1, 3);
    }

    public void setPlaneColor(double[] planecolor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (planecolor == null) {
            this.removeValue(ASName.k_PC);
        } else {
            CosArray array = this.setDictionaryArrayValue(ASName.k_PC, 1, planecolor);
            array.setName(0, ASName.k_DeviceRGB);
        }
    }

    public boolean hasPlaneColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PC);
    }

    public Object[] getOrientation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_O);
        if (cosObject == null) {
            return null;
        }
        Object o = cosObject.getValue();
        if (o instanceof ArrayList) {
            int size = ((ArrayList)o).size();
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = ((ArrayList)o).get(i);
            }
            return values;
        }
        return null;
    }

    public void setOrientation(Object[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidDocumentException("Orientation is a required entry and can't be null");
        }
        this.setDictionaryArrayValue(ASName.k_O, this.arrayToList(value));
    }

    private List<Object> arrayToList(Object[] value) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < value.length; ++i) {
            list.add(value[i]);
        }
        return list;
    }

    public boolean hasOrientation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public double[] getCenter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_C);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setCenter(double[] cor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_C, cor);
    }

    public boolean hasCenter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }
}

