/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaPlayerInfoArray;

public class PDFMediaPlayers
extends PDFCosDictionary {
    PDFMediaPlayers(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaPlayers newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaPlayers pdfObject = new PDFMediaPlayers(cosObject);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFMediaPlayers getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaPlayers pdfObject = (PDFMediaPlayers)PDFCosObject.getCachedInstance(cosObject, PDFMediaPlayers.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaPlayers(cosObject);
        }
        return pdfObject;
    }

    public PDFMediaPlayerInfoArray getMustUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayerInfoArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_MU));
    }

    public void setMustUse(PDFMediaPlayerInfoArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_MU, children.getCosArray());
    }

    public boolean hasMustUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MU);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_MediaPlayers);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFMediaPlayerInfoArray getMayUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayerInfoArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_A));
    }

    public void setMayUse(PDFMediaPlayerInfoArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_A, children.getCosArray());
    }

    public boolean hasMayUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_A);
    }

    public PDFMediaPlayerInfoArray getMustNotUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayerInfoArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_NU));
    }

    public void setMustNotUse(PDFMediaPlayerInfoArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_NU, children.getCosArray());
    }

    public boolean hasMustNotUse() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NU);
    }
}

