/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFMovieActivation
extends PDFCosDictionary {
    private PDFMovieActivation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMovieActivation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMovieActivation pdfObject = new PDFMovieActivation(cosObject);
        return pdfObject;
    }

    public static PDFMovieActivation getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMovieActivation pdfObject = (PDFMovieActivation)PDFCosObject.getCachedInstance(cosObject, PDFMovieActivation.class);
        if (pdfObject == null) {
            pdfObject = new PDFMovieActivation(cosObject);
        }
        return pdfObject;
    }

    public boolean getShowControls() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_ShowControls);
    }

    public void setShowControls(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_ShowControls, value);
    }

    public boolean hasShowControls() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_ShowControls);
    }

    public CosArray getFWScale() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_FWScale);
    }

    public void setFWScale(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_FWScale, value);
    }

    public boolean hasFWScale() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FWScale);
    }

    public double getStartAsFixed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Start);
    }

    public void setStart(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Start, value);
    }

    public int getStartAsInteger() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Start);
    }

    public void setStart(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Start, value);
    }

    public ASString getStartAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Start);
    }

    public void setStart(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_Start, value);
    }

    public void setStart(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_Start, value);
    }

    public CosArray getStartAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Start);
    }

    public void setStart(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Start, value);
    }

    public boolean hasStart() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Start);
    }

    public double getDurationAsFixed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Duration);
    }

    public void setDuration(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Duration, value);
    }

    public int getDurationAsInteger() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Duration);
    }

    public void setDuration(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Duration, value);
    }

    public ASString getDurationAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Duration);
    }

    public void setDuration(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_Duration, value);
    }

    public void setDuration(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_Duration, value);
    }

    public CosArray getDurationAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Duration);
    }

    public void setDuration(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Duration, value);
    }

    public boolean hasDuration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Duration);
    }

    public double getVolume() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Volume);
    }

    public void setVolume(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Volume, value);
    }

    public boolean hasVolume() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Volume);
    }

    public ASName getMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Mode);
    }

    public void setMode(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Mode);
        } else if (value.equals(ASName.k_Once) || value.equals(ASName.k_Open) || value.equals(ASName.k_Repeat) || value.equals(ASName.k_Palindrome)) {
            this.setDictionaryNameValue(ASName.k_Mode, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Mode.");
        }
    }

    public boolean hasMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Mode);
    }

    public CosArray getFWPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_FWPosition);
    }

    public void setFWPosition(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_FWPosition, value);
    }

    public boolean hasFWPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_FWPosition);
    }

    public boolean getSynchronous() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_Synchronous);
    }

    public void setSynchronous(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Synchronous, value);
    }

    public boolean hasSynchronous() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Synchronous);
    }

    public double getRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_Rate);
    }

    public void setRate(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Rate, value);
    }

    public boolean hasRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Rate);
    }
}

