/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFBestEffortRendition;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClip;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaPlayParams;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaScreenParams;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMustHonorRendition;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRendition;

public class PDFRenditionMedia
extends PDFRendition {
    private PDFRenditionMedia(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRenditionMedia newInstance(PDFDocument pdfDocument, ASName key_Subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (key_Subtype == null) {
            throw new PDFInvalidDocumentException("Subtype is required when creating newInstance of PDFRenditionMedia.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRenditionMedia pdfObject = new PDFRenditionMedia(cosObject);
        pdfObject.setType();
        pdfObject.setSubtype();
        return pdfObject;
    }

    public static PDFRenditionMedia getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRenditionMedia pdfObject = (PDFRenditionMedia)PDFCosObject.getCachedInstance(cosObject, PDFRenditionMedia.class);
        if (pdfObject == null) {
            pdfObject = new PDFRenditionMedia(cosObject);
        }
        return pdfObject;
    }

    public boolean hasMediaClip() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }

    public PDFMediaClip getMediaClip() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaClip.getInstance(this.getDictionaryCosObjectValue(ASName.k_C));
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_Rendition);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, ASName.k_MR);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFBestEffortRendition getBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFBestEffortRendition.getInstance(this.getDictionaryCosObjectValue(ASName.k_BE));
    }

    public void setBE(PDFBestEffortRendition value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_BE, value);
    }

    public boolean hasBE() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BE);
    }

    public PDFMediaScreenParams getSP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaScreenParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_SP));
    }

    public void setSP(PDFMediaScreenParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_SP, value);
    }

    public boolean hasSP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SP);
    }

    public PDFMediaPlayParams getP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMediaPlayParams.getInstance(this.getDictionaryCosObjectValue(ASName.k_P));
    }

    public void setP(PDFMediaPlayParams value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_P, value);
    }

    public boolean hasP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_P);
    }

    public void setName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_N, value);
    }

    public void setName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_N, value);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_N);
    }

    public PDFMustHonorRendition getMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMustHonorRendition.getInstance(this.getDictionaryCosObjectValue(ASName.k_MH));
    }

    public void setMH(PDFMustHonorRendition value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_MH, value);
    }

    public boolean hasMH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MH);
    }
}

