/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;

public class PDFPageBoxColor
extends PDFCosDictionary {
    private PDFPageBoxColor(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageBoxColor getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageBoxColor pdfObject = (PDFPageBoxColor)PDFCosObject.getCachedInstance(cosObject, PDFPageBoxColor.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageBoxColor(cosObject);
        }
        return pdfObject;
    }

    public double[] getGuidelinesColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_C)) {
            double[] defaultValues = new double[3];
            for (int i = 0; i < 3; ++i) {
                defaultValues[i] = 0.0;
            }
            return defaultValues;
        }
        return this.getDictionaryArrayValue(ASName.k_C).getArrayDouble();
    }

    public void setGuidelinesColor(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_C, value);
    }

    public double getGuidelinesWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_W)) {
            return 0.0;
        }
        return this.getDictionaryDoubleValue(ASName.k_W);
    }

    public void setGuidelinesWidth(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_W, value);
    }

    public PDFBorderStyle.Style getGuidelinesStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.dictionaryContains(ASName.k_S)) {
            return PDFBorderStyle.Style.Solid;
        }
        return PDFBorderStyle.Style.getInstance(this.getDictionaryNameValueAsString(ASName.k_S));
    }

    public void setGuidelinesStyle(PDFBorderStyle.Style style) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (style == null) {
            this.removeValue(ASName.k_S);
        } else {
            if (style != PDFBorderStyle.Style.Solid && style != PDFBorderStyle.Style.Dashed) {
                throw new PDFInvalidParameterException("Style expected Solid OR Dashed for PDFPageBoxColor, found" + (Object)((Object)style));
            }
            this.setDictionaryNameValue(ASName.k_S, style.getValue());
        }
    }

    public PDFDashPattern getGuidelineDashPattern() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] pattern = new double[]{};
        int phase = 0;
        if (this.dictionaryContains(ASName.k_D)) {
            CosArray cosArray = this.getDictionaryArrayValue(ASName.k_D);
            CosObject cosObject = cosArray.get(0);
            if (!(cosObject instanceof CosArray)) {
                return null;
            }
            CosArray patternArray = (CosArray)cosObject;
            pattern = patternArray.getArrayDouble();
            phase = cosArray.getInt(1);
        }
        return new PDFDashPattern(pattern, phase);
    }

    public void setGuideLineDashPattern(PDFDashPattern dashPattern) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dashPattern == null) {
            this.removeValue(ASName.k_D);
        } else {
            CosArray cosArray = PDFPageBoxColor.newCosArray(this.getPDFDocument());
            double[] pattern = dashPattern.getPattern();
            CosArray patternArray = null;
            patternArray = pattern == null ? PDFPageBoxColor.newCosArray(this.getPDFDocument()) : PDFPageBoxColor.makeCosArray(this.getPDFDocument(), 0, pattern, 0, pattern.length);
            cosArray.set(0, patternArray);
            cosArray.setInt(1, dashPattern.getPhase());
            this.setDictionaryValue(ASName.k_D, cosArray);
        }
    }
}

