/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class CaptureResolutionBox
extends Jpeg2000Box {
    private int verticalCaptureGridResolutionNumerator;
    private int verticalCaptureGridResolutionDenominator;
    private int horizontalCaptureGridResolutionNumerator;
    private int horizontalCaptureGridResolutionDenominator;
    private byte verticalCaptureGridResolutionExponent;
    private byte horizontalCaptureGridResolutionExponent;

    CaptureResolutionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getVerticalCaptureGridResolutionNumerator() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalCaptureGridResolutionNumerator;
    }

    public int getVerticalCaptureGridResolutionDenominator() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalCaptureGridResolutionDenominator;
    }

    public int getHorizontalCaptureGridResolutionNumerator() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalCaptureGridResolutionNumerator;
    }

    public int getHorizontalCaptureGridResolutionDenominator() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalCaptureGridResolutionDenominator;
    }

    public byte getVerticalCaptureGridResolutionExponent() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalCaptureGridResolutionExponent;
    }

    public byte getHorizontalCaptureGridResolutionExponent() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalCaptureGridResolutionExponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.verticalCaptureGridResolutionNumerator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.verticalCaptureGridResolutionDenominator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.horizontalCaptureGridResolutionNumerator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.horizontalCaptureGridResolutionDenominator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.verticalCaptureGridResolutionExponent = (byte)boxContents.read();
            this.horizontalCaptureGridResolutionExponent = (byte)boxContents.read();
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

