/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class ChannelDefinitionBox
extends Jpeg2000Box {
    private int numberOfChannelDescriptions;
    private int[] channelIndex;
    private int[] channelType;
    private int[] channelAssociation;

    ChannelDefinitionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfChannelDecriptions() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfChannelDescriptions;
    }

    public int[] getChannelIndicesList() throws IOException {
        this.lazilyPopulateFields();
        return this.channelIndex;
    }

    public int[] getChannelTypeList() throws IOException {
        this.lazilyPopulateFields();
        return this.channelType;
    }

    public int[] getChannelAssociationList() throws IOException {
        this.lazilyPopulateFields();
        return this.channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.numberOfChannelDescriptions = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.channelIndex = new int[this.numberOfChannelDescriptions];
            this.channelType = new int[this.numberOfChannelDescriptions];
            this.channelAssociation = new int[this.numberOfChannelDescriptions];
            for (int i = 0; i < this.numberOfChannelDescriptions; ++i) {
                this.channelIndex[i] = Jpeg2000Utils.bytesToInteger(boxContents, 2);
                this.channelType[i] = Jpeg2000Utils.bytesToInteger(boxContents, 2);
                this.channelAssociation[i] = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

