/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourSpecificationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import java.io.IOException;

public class ColourGroupBox
extends Jpeg2000Box {
    private Jpeg2000BoxesList<ColourSpecificationBox> colourSpecificationBoxesList;

    ColourGroupBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public Jpeg2000BoxesList<ColourSpecificationBox> getColourSpecificationBoxesList() throws IOException {
        this.lazilyPopulateFields();
        return this.colourSpecificationBoxesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.colourSpecificationBoxesList = new Jpeg2000BoxesList();
            while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                if (innerBoxInfo.getType() != Jpeg2000BoxType.colourSpecificationBox) continue;
                this.colourSpecificationBoxesList.add(new ColourSpecificationBox(innerBoxInfo));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.colourSpecificationBoxesList != null) {
                this.colourSpecificationBoxesList.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

