/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class DefaultDisplayResolutionBox
extends Jpeg2000Box {
    private int verticalDisplayGridResolutionNumerator;
    private int verticalDisplayGridResolutionDenominator;
    private int horizontalDisplayGridResolutionNumerator;
    private int horizontalDisplayGridResolutionDenominator;
    private byte verticalDisplayGridResolutionExponent;
    private byte horizontalDisplayGridResolutionExponent;

    DefaultDisplayResolutionBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getVerticalDisplayGridResolutionNumerator() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalDisplayGridResolutionNumerator;
    }

    public int getVerticalDisplayGridResolutionDenominator() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalDisplayGridResolutionDenominator;
    }

    public int getHorizontalDisplayGridResolutionNumerator() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalDisplayGridResolutionNumerator;
    }

    public int getHorizontalDisplayGridResolutionDenominator() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalDisplayGridResolutionDenominator;
    }

    public byte getVerticalDisplayGridResolutionExponent() throws IOException {
        this.lazilyPopulateFields();
        return this.verticalDisplayGridResolutionExponent;
    }

    public byte getHorizontalDisplayGridResolutionExponent() throws IOException {
        this.lazilyPopulateFields();
        return this.horizontalDisplayGridResolutionExponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.verticalDisplayGridResolutionNumerator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.verticalDisplayGridResolutionDenominator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.horizontalDisplayGridResolutionNumerator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.horizontalDisplayGridResolutionDenominator = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.verticalDisplayGridResolutionExponent = (byte)boxContents.read();
            this.horizontalDisplayGridResolutionExponent = (byte)boxContents.read();
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

