/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.math.BigInteger;

public class DigitalSignatureBox
extends Jpeg2000Box {
    private int signatureType;
    private int sourcePointerType;
    private BigInteger sourceDataOffset;
    private BigInteger sourceDataLength;
    private InputByteStream signatureData;

    DigitalSignatureBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getSignatureType() throws IOException {
        this.lazilyPopulateFields();
        return this.signatureType;
    }

    public int getSourcePointerType() throws IOException {
        this.lazilyPopulateFields();
        return this.sourcePointerType;
    }

    public BigInteger getSourceDataOffset() throws IOException {
        this.lazilyPopulateFields();
        return this.sourceDataOffset;
    }

    public BigInteger getSourceDataLength() throws IOException {
        this.lazilyPopulateFields();
        return this.sourceDataLength;
    }

    public InputByteStream getSignatureData() throws IOException {
        this.lazilyPopulateFields();
        return this.signatureData != null ? this.signatureData.slice() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.signatureType = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.sourcePointerType = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            if (this.sourcePointerType != 1) {
                byte[] sourceData = new byte[8];
                boxContents.read(sourceData);
                this.sourceDataOffset = new BigInteger(sourceData);
                boxContents.read(sourceData);
                this.sourceDataLength = new BigInteger(sourceData);
            }
            this.signatureData = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.signatureData != null) {
                this.signatureData.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

